/*
 * TranslateAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/TranslateAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

/****** MoleculeTranslateAction *****/

// memento to remember the state when undoing

//class MoleculeTranslateState : public ActionState {
//public:
//  MoleculeTranslateState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeTranslateAction::NAME[] = "translate-mol";

MoleculeTranslateAction::MoleculeTranslateAction() :
  Action(NAME)
{}

MoleculeTranslateAction::~MoleculeTranslateAction()
{}

void MoleculeTranslate(Vector &x, bool periodic) {
  ValueStorage::getInstance().setCurrentValue(MoleculeTranslateAction::NAME, x);
  ValueStorage::getInstance().setCurrentValue("periodic", periodic);
  ActionRegistry::getInstance().getActionByName(MoleculeTranslateAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeTranslateAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryVector(NAME, false, ValueStorage::getInstance().getDescription(NAME));
  dialog->queryBoolean("periodic", ValueStorage::getInstance().getDescription("periodic"));

  return dialog;
}

Action::state_ptr MoleculeTranslateAction::performCall() {
  molecule *mol = NULL;
  Vector x;
  bool periodic = false;

  ValueStorage::getInstance().queryCurrentValue(NAME, x);
  ValueStorage::getInstance().queryCurrentValue("periodic", periodic);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Translating all ions by given vector." << endl);
    if (periodic)
      mol->TranslatePeriodically((const Vector *)&x);
    else
      mol->Translate((const Vector *)&x);
  }
  return Action::success;
}

Action::state_ptr MoleculeTranslateAction::performUndo(Action::state_ptr _state) {
//  MoleculeTranslateState *state = assert_cast<MoleculeTranslateState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeTranslateAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeTranslateAction::canUndo() {
  return false;
}

bool MoleculeTranslateAction::shouldUndo() {
  return false;
}

const string MoleculeTranslateAction::getName() {
  return NAME;
}
