/*
 * FillWithMoleculeAction.hpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#ifndef FILLWITHMOLECULEACTION_HPP
#define FILLWITHMOLECULEACTION_HPP

#include "Actions/Action.hpp"
#include "Actions/Process.hpp"
#include "LinearAlgebra/Vector.hpp"

class MoleculeListClass;

void MoleculeFillWithMolecule(std::string &fillername, Vector &distances, Vector &lengths, double MaxDistance, bool DoRotate);

class MoleculeFillWithMoleculeAction : public Action {
  friend void MoleculeFillWithMolecule(std::string &fillername, Vector &distances, Vector &lengths, double MaxDistance, bool DoRotate);

public:
  MoleculeFillWithMoleculeAction();
  virtual ~MoleculeFillWithMoleculeAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};


#endif // FILLWITHMOLECULEACTION_HPP
