/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorsQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// Vectors Queries
Dialog::VectorsQuery::VectorsQuery(std::string title,bool _check, std::string _description) :
  Query(title, _description),
  check(_check)
{}

Dialog::VectorsQuery::~VectorsQuery()
{}

void Dialog::VectorsQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

