/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * WorldTime.cpp
 *
 *  Created on: Feb 7, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "WorldTime.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Notification.hpp"
#include "CodePatterns/Singleton_impl.hpp"

unsigned int WorldTime::CurrentTime = 0;

WorldTime::WorldTime() :
  Observable("WorldTime"),
  StepWidth(0.)
{
  // observable stuff
  Channels *OurChannel = new Channels;
  Observable::insertNotificationChannel( std::make_pair(static_cast<Observable *>(this), OurChannel) );
  // add instance for each notification type
  for (size_t type = 0; type < NotificationType_MAX; ++type)
    OurChannel->addChannel(type);
}

WorldTime::~WorldTime()
{}

void WorldTime::setStepWidth(const double _width)
{
  LOG(1, "INFO: Setting current world time to " << _width << ".");
  StepWidth = _width;
}

double WorldTime::getStepWidth() const
{
  return StepWidth;
}

void WorldTime::setTime(const unsigned int _time)
{
  if (WorldTime::CurrentTime != _time) {
    OBSERVE;
    NOTIFY(TimeChanged);
    WorldTime::CurrentTime = _time;
  }
}

CONSTRUCT_SINGLETON(WorldTime)
