/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ObserverBoxStub.cpp
 *
 *  Created on: Dec 22, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Box.hpp"

#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Notification.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"


Box::Box(RealSpaceMatrix _M) :
  Observable("Box"),
  M( new RealSpaceMatrix(_M) ),
  Minv( new RealSpaceMatrix )
{
  // observable stuff
  Channels *OurChannel = new Channels;
  Observable::insertNotificationChannel( std::make_pair(static_cast<Observable *>(this), OurChannel) );
  // add instance for each notification type
  OurChannel->addChannel(Box::MatrixChanged);
  *Minv = M->invert();
}

Box::~Box()
{
  delete M;
  delete Minv;
}

const RealSpaceMatrix &Box::getM() const
{
  return *M;
}

const RealSpaceMatrix &Box::getMinv() const
{
  return *Minv;
}

Vector Box::enforceBoundaryConditions(const Vector &point) const{
  return point;
}

const BoundaryConditions::Conditions_t & Box::getConditions() const
{
  return conditions.get();
}

double Box::periodicDistanceSquared(const Vector &point1,const Vector &point2) const
{
  return point1.DistanceSquared(point2);
}

bool Box::isValid(const Vector &p) const
{
  return true;
}

void Box::setM(const RealSpaceMatrix &_M)
{
  OBSERVE;
  NOTIFY(MatrixChanged);
  delete M;
  M = new RealSpaceMatrix(_M);
  *Minv = M->invert();
}
