/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AtomObserver.cpp
 *
 *  Created on: Nov 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "AtomObserver.hpp"

#include "CodePatterns/Singleton_impl.hpp"

#include "Atom/atom.hpp"
#include "Atom/atom_observable.hpp"


/** Private constructor of class AtomObserver.
 *
 */
AtomObserver::AtomObserver() :
  Relay(std::string("AtomObserver"))
{
  Channels *OurChannel = new Channels();
  Observable::insertNotificationChannel( std::make_pair(static_cast<Observable *>(this), OurChannel) );
  OurChannel->addChannel(AtomObservable::PositionChanged);
  OurChannel->addChannel(AtomObservable::ElementChanged);
  OurChannel->addChannel(AtomObservable::TrajectoryChanged);
}

/** Private Destructor of class AtomObserver.
 *
 */
AtomObserver::~AtomObserver()
{}

/** Function to call when a new atom has been created.
 *
 * @param res
 */
void AtomObserver::AtomInserted(atom *res)
{
  res->signOn(this, AtomObservable::PositionChanged);
  res->signOn(this, AtomObservable::ElementChanged);
  res->signOn(this, AtomObservable::TrajectoryChanged);
}

/** Function to call when an atom is about to get deleted.
 *
 * @param res
 */
void AtomObserver::AtomRemoved(atom *res)
{
  res->signOff(this, AtomObservable::PositionChanged);
  res->signOff(this, AtomObservable::ElementChanged);
  res->signOff(this, AtomObservable::TrajectoryChanged);
}

CONSTRUCT_SINGLETON(AtomObserver)
