import re, os, os.path, sys, operator

def ReadSettings():
    if len(sys.argv) >= 2:
        global opt_basename
        opt_basename = sys.argv[1]
    else:
        print 'usage: boxmaker.py <basename>'
        exit()
    
    with open('boxmaker.'+opt_basename) as f:
        for line in f:
            if len(line) > 0 and line[0] != '#':
                L, S, R = line.partition('=')
                varname = 'opt_' + L.strip()
                
                exec('global %s\n%s="%s"' % (varname, varname, R.strip()))
                
    # IT'S A HACK
    global opt_number
    
    if len(sys.argv) == 3:
        opt_number = sys.argv[2]
    
    
def ReadUnits():    
    lines = []
    with open(opt_tremofiledir+opt_basename+'.tremolo') as f:
        for line in f:
            if len(line) > 0 and line[0] != '#':
                line = line.strip()
                lines.append(line.strip())
                
                if 'systemofunits' in line:
                    L, S, SOU = line.partition('=')
                    SOU = SOU.strip()[:-1]
                    
    if SOU == 'custom':
        units = {}
        quantities = ['length', 'mass']
        
        for quantity in quantities:
            units[quantity] = [None, None] # scaling factor and unit.
        
        for line in lines:
            for quantity in quantities:
                if quantity in line:
                    L, S, R = line.partition('=')
                    R = R.strip()[:-1] # remove semicolon
                    
                    if 'scalingfactor' in line:
                        units[quantity][0] = R
                    else:
                        units[quantity][1] = R
                        
    elif SOU == 'kcalpermole':
        units = {'length': ['1', 'angstrom'], 'mass': ['1', 'u']}
    
    elif SOU == 'evolt':
        units = {'length': ['1', 'angstrom'], 'mass': ['1', 'u']}
        
    else: # SI
        units = {'length': ['1', 'm'], 'mass': ['1', 'kg']}
                                         
    return units
    
    
def ConvertUnits(have, want):
    # redo with pipes?
    ret = os.system("units '%s' '%s' > temp_units_output" % (have, want))
    
    if ret == 0:
        with open('temp_units_output') as f:
            line = f.readline()
            
        os.system('rm temp_units_output')
            
        return float(line[3:-1])
    else:
        raise NameError('UnitError')
    
    
def UpdateSettings():
    global opt_molarmass, opt_density, opt_number
    
    units = ReadUnits()
    
    have = opt_molarmass
    want = '%s*%s / mol' % tuple(units['mass'])
    opt_molarmass = ConvertUnits(have, want)
    
    have = opt_density
    want = '(%s*%s) ' % tuple(units['mass']) + '/ (%s*%s)**3' % tuple(units['length'])
    opt_density = ConvertUnits(have, want)
    
    nvec = opt_number.split()
    if len(nvec) == 3:
        opt_number = [0]*3
        
        for i in range(3):
            opt_number[i] = int(nvec[i])
    else:
        opt_number = int(opt_number)
        
        
def FindNearestCube(n):
    global opt_number
    
    newroot = round(opt_number**(1./3))
    
    opt_number = int(newroot**3)
    print 'warning: number changed to %d' % opt_number
    
    return [int(newroot)] * 3
        
        
def FindBestCuboid(n):
    # prime factors of n
    # taken from http://www.hsg-kl.de/faecher/inf/python/listen/index.php, "Beispiel 2"
    
    F = []

    while n%2 == 0:
        F.append(2)
        n = n/2
    while n%3 == 0:
        F.append(3)
        n = n/3
    
    t = 5
    diff = 2
    
    while t*t <= n:
        while n%t == 0:
            F.append(t)
            n = n/t
        t = t + diff
        diff = 6 - diff
    if n > 1:
        F.append(n)
        
    # even distribution of current biggest prime to each vector -> similar sizes
    if len(F) < 3:
        print 'warning: not enough prime factors - falling back to cubic placement'
        return FindNearestCube(n, mlen)
    
    F.sort()
    distri = [[],[],[]]
    current = 0
    
    for primfaktor in F:
        distri[current].append(primfaktor)
        current += 1
        if current == 3:
            current = 0
            
    result = []
    
    print 'box used:',
    
    for i in range(3):
        a = reduce(operator.mul, distri[i])
        print a,
        result.append(int(a))
        
    print
    return result
    
    
def GetSourceBBabs():
    bbmax = [0.0]*3
    bbmin = [0.0]*3
    
    s_name_ext = os.path.basename(opt_source).rsplit('.',1)
    s_namepart = s_name_ext[0]
    
    if len(s_name_ext[0])> 1:
        s_ext = s_name_ext[1]
    else:
        s_ext = ''
    
    # convert from any format to xyz
    os.system('molecuilder -o xyz --parse-tremolo-potentials %s -i temp_source.xyz -l %s' % (opt_potentialsfiledir+opt_basename+'.potentials', opt_source))
        
    with open('temp_source.xyz') as f:
        N = int(f.readline())
        comment = f.readline()
            
        for i in xrange(N):
            buf = f.readline()
            xyz = buf.split()[1:]
            
            for i in range(3):
                bbmax[i] = max(bbmax[i], float(xyz[i]))
                bbmin[i] = min(bbmin[i], float(xyz[i]))

    bb = [0.0]*3
    
    for i in range(3):
        bb[i] = bbmax[i] - bbmin[i]
        
    
    os.system('rm temp_source.*')
    return bb


ReadSettings()
UpdateSettings()


if type(opt_number) == type([]):
    nbox = opt_number
else:
    if opt_constraint == 'cube':
        nbox = FindNearestCube(opt_number)
    else:
        nbox = FindBestCuboid(opt_number)

avogadro =  6.022143e23
VolumePerMolecule = opt_molarmass / (avogadro * opt_density)

try:
    bb = GetSourceBBabs()
    print '======== BBOX:', bb
    s = (VolumePerMolecule / (bb[0]*bb[1]*bb[2])) ** (1./3)
    
    if s < 0:
        print 'warning: molecular cells will overlap'
    
    for i in range(3):
        bb[i] = bb[i]*s
        
    cell = bb
except ZeroDivisionError:
    print 'warning:  singularity in bounding box, using cubic cell'
    cell = [VolumePerMolecule**(1./3)] * 3
    
print '======== CELL: ', cell

import pyMoleCuilder as mol

mol.CommandVerbose('0')
mol.ParserParseTremoloPotentials(opt_potentialsfiledir+opt_basename+'.potentials')
mol.WorldInput(opt_source)
mol.WorldCenterInBox('%f 0 0 %f 0 %f' % tuple(cell))
mol.WorldRepeatBox('%d %d %d' % tuple(nbox))
mol.WorldOutput('out.data')
mol.WorldOutput('out.xyz')

domain = [0.0]*3

for i in range(3):
    domain[i] = cell[i]*nbox[i]
    
print  '======== DOMAIN: ', domain
