/*
 * MPQCDataMap.hpp
 *
 *  Created on: 28.07.2012
 *      Author: heber
 */

#ifndef MPQCDATAMAP_HPP_
#define MPQCDATAMAP_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/fusion/container/map.hpp>

#include "Jobs/MPQCDataFused.hpp"

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate data members in MPQCData and their type.
 *
 * This lets us resolves any ambiguitites of types in MPQCData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
    boost::fusion::pair<MPQCDataFused::energy_total, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_eigenvalues, Histogram >
  ,  boost::fusion::pair<MPQCDataFused::forces, std::vector< std::vector<double> > >
  ,  boost::fusion::pair<MPQCDataFused::times_walltime, double> >
MPQCDataMap_t;

#endif /* MPQCDATAMAP_HPP_ */
