/*
 * memoryusageobserverunittest.cpp
 */


using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "memoryallocator.hpp"
#include "memoryusageobserver.hpp"
#include "memoryusageobserverunittest.hpp"

/********************************************** Test classes **************************************/
// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( MemoryUsageObserverTest );


void MemoryUsageObserverTest::setUp()
{
};


void MemoryUsageObserverTest::tearDown()
{
  MemoryUsageObserver::purgeInstance();
};

/**
 * UnitTest for getInstance()
 */
void MemoryUsageObserverTest::getInstanceReturnsMemoryUsageObserverTest()
{
  CPPUNIT_ASSERT_EQUAL(true, MemoryUsageObserver::getInstance() != NULL);
};

/**
 * UnitTest for getInstance()
 */
void MemoryUsageObserverTest::getInstanceTwiceReturnsSameInstanceTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::getInstanceTwiceReturnsSameInstanceTest - i");
  MemoryUsageObserver::getInstance()->addMemory(i, sizeof(int));
  CPPUNIT_ASSERT_EQUAL(sizeof(int), MemoryUsageObserver::getInstance()->getUsedMemorySize());
  CPPUNIT_ASSERT_EQUAL(sizeof(int), MemoryUsageObserver::getInstance()->getUsedMemorySize());
};

/**
 * UnitTest for getInstance()
 */
void MemoryUsageObserverTest::getInstanceAfterPurgeInstanceReturnsNewInstanceTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::getInstanceAfterPurgeInstanceReturnsNewInstanceTest - i");
  MemoryUsageObserver::getInstance()->addMemory(i, sizeof(int));
  CPPUNIT_ASSERT_EQUAL(sizeof(int), MemoryUsageObserver::getInstance()->getUsedMemorySize());
  MemoryUsageObserver::purgeInstance();
  CPPUNIT_ASSERT_EQUAL((size_t) 0, MemoryUsageObserver::getInstance()->getUsedMemorySize());
};

/**
 * UnitTest for addMemory() and removeMemory()
 */
void MemoryUsageObserverTest::addAndRemoveMemoryTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::addAndRemoveMemoryTest - i");
  MemoryUsageObserver::getInstance()->addMemory(i, sizeof(int));
  CPPUNIT_ASSERT_EQUAL(sizeof(int), MemoryUsageObserver::getInstance()->getUsedMemorySize());
  MemoryUsageObserver::getInstance()->removeMemory(i);
  CPPUNIT_ASSERT_EQUAL((size_t) 0, MemoryUsageObserver::getInstance()->getUsedMemorySize());
};

/**
 * UnitTest for addMemory() and removeMemory()
 */
void MemoryUsageObserverTest::removeNonTrackedMemoryDoesNotCauseACrashTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::removeNonTrackedMemoryDoesNotCauseACrashTest - i");
  MemoryUsageObserver::getInstance()->removeMemory(i);
  CPPUNIT_ASSERT_EQUAL((size_t) 0, MemoryUsageObserver::getInstance()->getUsedMemorySize());
};

/**
 * UnitTest for addMemory() and removeMemory()
 */
void MemoryUsageObserverTest::addMemoryTwiceTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::addMemoryTwiceTest - i");
  int* j = Malloc<int>(1, "MemoryUsageObserverTest::addMemoryTwiceTest - j");
  MemoryUsageObserver::getInstance()->addMemory(i, sizeof(int));
  MemoryUsageObserver::getInstance()->addMemory(j, sizeof(int));
  CPPUNIT_ASSERT_EQUAL(2 * sizeof(int), MemoryUsageObserver::getInstance()->getUsedMemorySize());
};

/**
 * UnitTest for addMemory() and removeMemory()
 */
void MemoryUsageObserverTest::addMemoryAndChangeSizeOfAddedMemoryTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::addMemoryAndChangeSizeOfAddedMemoryTest - i");
  MemoryUsageObserver::getInstance()->addMemory(i, 2 * sizeof(int));
  MemoryUsageObserver::getInstance()->addMemory(i, sizeof(int));
  CPPUNIT_ASSERT_EQUAL(sizeof(int), MemoryUsageObserver::getInstance()->getUsedMemorySize());
};

/**
 * UnitTest for getMaximumUsedMemory()
 */
void MemoryUsageObserverTest::addMemoryChangeSizeOfAddedMemoryAndGetMaximumSizeTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::addMemoryChangeSizeOfAddedMemoryAndGetMaximumSizeTest - i");
  MemoryUsageObserver::getInstance()->addMemory(i, 2 * sizeof(int));
  MemoryUsageObserver::getInstance()->addMemory(i, sizeof(int));
  CPPUNIT_ASSERT_EQUAL(2 * sizeof(int), MemoryUsageObserver::getInstance()->getMaximumUsedMemory());
};

/**
 * UnitTest for getMaximumUsedMemory()
 */
void MemoryUsageObserverTest::addMemoryRemoveMemoryAndGetMaximumSizeTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::addMemoryRemoveMemoryAndGetMaximumSizeTest - i");
  MemoryUsageObserver::getInstance()->addMemory(i, sizeof(int));
  MemoryUsageObserver::getInstance()->removeMemory(i);
  CPPUNIT_ASSERT_EQUAL(sizeof(int), MemoryUsageObserver::getInstance()->getMaximumUsedMemory());
};

/**
 * UnitTest for getPointersToAllocatedMemory()
 */
void MemoryUsageObserverTest::getPointersToAllocatedMemoryTest()
{
  int* i = Malloc<int>(1, "MemoryUsageObserverTest::getPointersToAllocatedMemoryTest - i");
  MemoryUsageObserver::getInstance()->addMemory(i, sizeof(int));
  CPPUNIT_ASSERT_EQUAL(i, (int*) MemoryUsageObserver::getInstance()->getPointersToAllocatedMemory().begin()->first);
};


/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
