/*
 * TesselationUnitTest.hpp
 *
 *  Created on: Aug 26, 2009
 *      Author: heber
 */

#ifndef TESSELATIONUNITTEST_HPP_
#define TESSELATIONUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


/*********************************************** includes ***********************************/

#include <cppunit/extensions/HelperMacros.h>

#include "LinkedCell/linkedcell.hpp"
#include "Tesselation/tesselation.hpp"

/********************************************** Test classes **************************************/

class TesselationTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( TesselationTest) ;
    CPPUNIT_TEST ( GetAllTrianglesTest );
    CPPUNIT_TEST ( ContainmentTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void GetAllTrianglesTest();
      void ContainmentTest();


private:
      static const double SPHERERADIUS;

      class Tesselation *TesselStruct;
      TesselPointSTLList Corners;
      class LinkedCell *LinkedList;
};



#endif /* TESSELATIONUNITTEST_HPP_ */
