/*
 * VMGFragmentController.hpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */

#ifndef VMGFRAGMENTCONTROLLER_HPP_
#define VMGFRAGMENTCONTROLLER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Fragmentation/Automation/SpecificFragmentController.hpp"

#include <map>
#include <vector>

#include "JobMarket/types.hpp"

#include "Fragmentation/Summation/Containers/MPQCData.hpp"
#include "Fragmentation/Summation/Containers/VMGData.hpp"
#include "Fragmentation/Summation/SetValues/Fragment.hpp"
#include "Fragmentation/Summation/SetValues/SamplingGrid.hpp"

/** This class uses SpecificFragmentController with functions to add specificly
 * VMGJobs.
 */
class VMGFragmentController : public SpecificFragmentController
{
public:
  VMGFragmentController(boost::asio::io_service &io_service) :
    SpecificFragmentController(io_service)
  {}
  virtual ~VMGFragmentController()
  {}

  bool createLongRangeJobs(
      const std::map<JobId_t, MPQCData> &fragmentData,
      const std::vector<SamplingGrid> &full_sampled_grid,
      const size_t near_field_cells,
      const size_t interpolation_degree);
  void getResults(std::map<JobId_t, VMGData> &fragmentData) {
    SpecificFragmentController::getResults<VMGData>(fragmentData);
  }
};


#endif /* VMGFRAGMENTCONTROLLER_HPP_ */
