/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SaveSelectedAtomsAsExtTypesAction.cpp
 *
 *  Created on: Apr 4, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/TremoloParser.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "SaveSelectedAtomsAsExtTypesAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SaveSelectedAtomsAsExtTypesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserSaveSelectedAtomsAsExtTypesAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  if (boost::filesystem::exists(params.filename)) {
    ELOG(1, "Specified exttypes file " << params.filename << " already exists.");

    return Action::failure;
  } else {
    const FormatParser<tremolo> &parser = FormatParserStorage::getInstance().getParser<tremolo>();

    LOG(1, "Creating exttypes file " << params.filename << " ... ");
    boost::filesystem::ofstream test;
    test.open(params.filename);
    const bool status = parser.saveAtomsInExttypes(test, World::getInstance().getSelectedAtoms(), params.id);
    test.close();

    if (status)
      return Action::success;
    else
      return Action::failure;
  }
}

Action::state_ptr ParserSaveSelectedAtomsAsExtTypesAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr ParserSaveSelectedAtomsAsExtTypesAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool ParserSaveSelectedAtomsAsExtTypesAction::canUndo() {
  return true;
}

bool ParserSaveSelectedAtomsAsExtTypesAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
