/*
 * GLWorldView.hpp
 *
 *  Created on: Auf 11, 2010
 *      Author: heber
 */

#ifndef GLWORLDVIEW_HPP_
#define GLWORLDVIEW_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt3D/qglview.h>

#include "CodePatterns/Observer/Observer.hpp"

#include "World.hpp"

class QKeyEvent;
class GLWorldScene;
class QGLPainter;

/** This class is the view on the 3D representation of the World, i.e. the whole
 * of all molecules (consisting of atoms).
 *
 */
class GLWorldView : public QGLView, public Observer
{
  Q_OBJECT
public:
  GLWorldView(QWidget *parent=0);
  virtual ~GLWorldView();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

public slots:
  void changeSignalled();

signals:
  void changed();
  void atomInserted(const atom *_atom);
  void atomRemoved(const atom *_atom);
  void moleculeInserted(const molecule *_molecule);
  void moleculeRemoved(const molecule *_molecule);
  void worldSelectionChanged();

protected:
  void initializeGL(QGLPainter *painter);
  void paintGL(QGLPainter *painter);
  void keyPressEvent(QKeyEvent *e);

private:
  GLWorldScene *worldscene;

  bool changesPresent;
  bool processingSelectionChanged; // workaround to prevent a loop in (atom_iterator <-> observer)
};



//#include "CodePatterns/Observer/Observer.hpp"
//#include "LinearAlgebra/Vector.hpp"
//#include "changetypes.hpp"
//
//class atom;
//class element;
//class molecule;
//
//class GLMoleculeView : public QGLWidget, public Observer
//{
//    Q_OBJECT
//
//public:
//
//    GLMoleculeView( QWidget* parent);
//    ~GLMoleculeView();
//
//public slots:
//
//    void    setXRotation( int degrees );
//    void    setYRotation( int degrees );
//    void    setZRotation( int degrees );
//    void    setScale( int distance );
//    void    setLightPosition( int *light );
//    void    setLightDiffuse( int *light );
//    void    setLightAmbient( int *light );
//    void    createDialogLight();
//    void    toggleMultiViewEnabled();
//
//    void    init( QLabel *ptr );
//    void    initCoordinates(QLabel *ptr);
//    void    createView();
//    void    hearMoleculeSelected(molecule *mol);
//    void    hearAtomSelected(molecule *mol, atom *Walker);
//    void    hearMoleculeChanged(molecule *mol, enum ChangesinMolecule type);
//    void    hearAtomChanged(molecule *mol, atom *Walker, enum ChangesinAtom type);
//    void    hearElementChanged(element *Runner, enum ChangesinElement type);
//    void    hearMoleculeAdded(molecule *mol);
//    void    hearAtomAdded(molecule *mol, atom *Walker);
//    void    hearMoleculeRemoved(molecule *mol);
//    void    hearAtomRemoved(molecule *mol, atom *Walker);
//
//signals:
//    void    notifyMoleculeSelected( molecule *mol );
//    void    notifyAtomSelected( molecule *mol, atom *Walker );
//    void    notifyMoleculeChanged( molecule *mol, enum ChangesinMolecule type );
//    void    notifyAtomChanged( molecule *mol, atom *Walker, enum ChangesinAtom type );
//    void    notifyElementChanged( element *Runner, enum ChangesinElement type );
//    void    notifyMoleculeAdded( molecule *mol);
//    void    notifyElementAdded( element *Runner);
//    void    notifyAtomAdded( molecule *mol, atom *Walker );
//    void    notifyMoleculeRemoved( molecule *mol );
//    void    notifyAtomRemoved( molecule *mol, atom *Walker );
//
//protected:
//
//    void    initializeGL();
//    void    paintGL();
//    void    resizeGL( int w, int h );
//    void    makeSphere(const Vector &x, double radius, const unsigned char color[3]);
//    void    makeCylinder(const Vector &x, const Vector &y, double radius, double height, const unsigned char color[3]);
//    void mousePressEvent(QMouseEvent* event);
//    void mouseReleaseEvent(QMouseEvent* event);
//
//public:
//
//    /** Update function as we are an Observer.
//     *
//     * @param publisher ref to Observable
//     */
//    void update(Observable *publisher);
//
//    /**
//     * This method is called when a special named change
//     * of the Observable occured
//     */
//    void recieveNotification(Observable *publisher, Notification_ptr notification);
//
//    /**
//     * This method is called when the observed object is destroyed.
//     */
//    void subjectKilled(Observable *publisher);
//
//
//private:
//
//    typedef std::map< size_t, node > AtomNodeMap;
//    typedef std::map< std::pair< size_t, size_t> , node > BondNodeMap;
//    typedef std::map< size_t, QGLMaterial *> ElementMaterialMap;
//
//    ElementMaterialMap ElementNoMaterialMap;
//    AtomNodeMap AtomsinSceneMap;
//    BondNodeMap BondsinSceneMap;
//
//    QGLMaterial* getMaterial(size_t);
//    QGLSceneNode* getAtom(size_t);
//    QGLSceneNode* getBond(size_t, size_t);
//
//    // old stuff
//
//    GLuint object;  // call list for the scene to be rendered
//    GLfloat xRot, yRot, zRot, scale;  // rotation angles and scaling (zoom)
//    Vector position;  //!< position of observer
//    Vector view;      //!< point along line of view
//    Vector top;       //!< giving upwards direction
//    Vector X,Y,Z;     //!< vectors defining the coordinate system
//    int width;        //!< width of window
//    int height;       //!< height of window
//
//  QLabel *StatusBar;  //!< pointer to status bar for messages
//  QLabel *CoordinatesBar; //!< pointer to coordinates bar for view port
//
//  GLfloat LightPosition[4];        //!< Light Position
//  GLfloat LightDiffuse[4];         //!< Diffuse Light Values
//  GLfloat LightAmbient[4];        //!< Ambient Light Values
//
//  QPoint LeftButtonPos;     //!< mouse position on mousePressEvent for LeftButton
//  QPoint MiddleButtonPos;   //!< mouse position on mousePressEvent for MidButton
//  QPoint RightButtonPos;    //!< mouse position on mousePressEvent for RightButton
//
//  unsigned char SelectionColor[3] ; //!< highlight color
//
//  bool isSignaller;
//
//  bool MultiViewEnabled;    //!< if true, split screen into four parts with additional xy,xz,yz views
//};

#endif /* GLWORLDVIEW_HPP_ */
