/*
 * ActionSequenze.hpp
 *
 *  Created on: Dec 17, 2009
 *      Author: crueger
 */

#ifndef ACTIONSEQUENZE_HPP_
#define ACTIONSEQUENZE_HPP_

#include "Actions/Action.hpp"

#include <deque>

/**
 * Store Actions for later use.
 */
class ActionSequence
{
public:
  typedef std::deque<Action*> actionSet;
  typedef std::deque<Action::state_ptr> stateSet;

  ActionSequence();
  virtual ~ActionSequence();

  void addAction(Action*);
  Action* removeLastAction();

  stateSet callAll();
  stateSet undoAll(stateSet);
  stateSet redoAll(stateSet);

  bool canUndo();
  bool shouldUndo();

private:
  actionSet actions;
};

#endif /* ACTIONSEQUENZE_HPP_ */
