/** \file graph.cpp
 * 
 * Function definitions for the class graph.
 * 
 */

#ifndef GRAPH_HPP_
#define GRAPH_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// STL headers
#include <map>
#include <multimap>

#include "molecules.hpp"

class Graph;
class SubGraph;
class Node;
class Edge;

/***************************************** Various graph-related STL defines ********************************/

#define NodeMap pair < int, class Node* >
#define EdgeMap multimap < class Node*, class Edge* >

/***************************************** Definition for classes ********************************/

/** Graph class containing the graphs behind molecules.
 */
class Graph
{
	NodeMap ListOfNodes;		//!< tree-list of all nodes in this graph
	EdgeMap ListOfEdges;		//!< tree-multi-list of all nodes, referenced to node id
};

/** Class describing subgraphs of the Class \a Graph.
 * SubGraph has its own node and edge lists, however also a pointer to its father graph
 * and hence access to its list as well. 
 */
class SubGraph : class Graph
{
	class Graph *FatherGraph;		//!< Graph whose subgraph we are
};

/** Class containing the nodes of a graph.
 */
class Node
{
	int	id;				//!< individual id of the node
	char *Name;		//!< Name of the node for pretty printing
};

/** Class containing egdes in a Graph strructure.
 */
class Edge
{
	class Node *leftnode;		//!< pointer to first node
	class Node *atomnode;		//!< pointer to second node
};



#endif /*GRAPH_HPP_*/
