/** \file element.cpp
 * 
 * Function implementations for the class element.
 * 
 */

#include "molecules.hpp"

/************************************* Functions for class element **********************************/

/** Constructor of class element.
 */
element::element() {
  Z = -1;
  No = -1;
  previous = NULL;
  next = NULL;
  sort = NULL;
};

/** Destructor of class element.
 */
element::~element() {};

/** Prints element data to \a *out.
 * \param *out outstream
 */
bool element::Output(ofstream *out) const
{ 
  if (out != NULL) {
    *out << name << "\t" << symbol << "\t" << period << "\t" << group << "\t" << block << "\t" << Z << "\t" << mass << "\t" << CovalentRadius << "\t" << VanDerWaalsRadius << endl;
    //*out << Z << "\t"  << fixed << setprecision(11) << showpoint << mass << "g/mol\t" << name << "\t" << symbol << "\t" << endl;
    return true;
  } else
    return false;
};

/** Prints element data to \a *out.
 * \param *out outstream
 * \param No  cardinal number of element
 * \param NoOfAtoms total number of atom of this element type
 */
bool element::Checkout(ofstream *out, const int No, const int NoOfAtoms) const
{ 
  if (out != NULL) {
    *out << "Ion_Type" << No << "\t" << NoOfAtoms << "\t" << Z << "\t1.0\t3\t3\t" << fixed << setprecision(11) << showpoint << mass << "\t" << name << "\t" << symbol <<endl;
    return true;
  } else
    return false;
};
