/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ObtainJobOperation.cpp
 *
 *  Created on: Feb 26, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "ObtainJobOperation.hpp"

#include <boost/bind.hpp>
#include "CodePatterns/Info.hpp"
#include "CodePatterns/Log.hpp"
#include "Jobs/FragmentJob.hpp"
#include "WorkerChoices.hpp"

/// Handle completion of a connect operation.
void ObtainJobOperation::handle_connect(const boost::system::error_code& e,
    boost::asio::ip::tcp::resolver::iterator endpoint_iterator)
{
  Info info(__FUNCTION__);
  if (!e)
  {
    // Successfully established connection. Start operation to read the list
    // of jobs. The connection::async_read() function will automatically
    // decode the data that is read from the underlying socket.
    LOG(1, "INFO: Receiving a job ...");
    connection_.async_read(job,
      boost::bind(&ObtainJobOperation::handle_ReceiveJob, this,
      boost::asio::placeholders::error));
  } else if (endpoint_iterator != boost::asio::ip::tcp::resolver::iterator()) {
    // Try the next endpoint.
    connection_.socket().close();
    boost::asio::ip::tcp::endpoint endpoint = *endpoint_iterator;
    connection_.socket().async_connect(endpoint,
      boost::bind(&ObtainJobOperation::handle_connect, this,
      boost::asio::placeholders::error, ++endpoint_iterator));
  } else {
    // An error occurred. Log it and return. Since we are not starting a new
    // operation the io_service will run out of work to do and the client will
    // exit.
    ELOG(1, e.message());
  }
}

/// Callback function when job has been received.
void ObtainJobOperation::handle_ReceiveJob(const boost::system::error_code& e)
{
  Info info(__FUNCTION__);

  LOG(1, "INFO: Received job #" << job->getId() << ".");

  AsyncOperation::handle_FinishOperation(e);
}
