/*
 * MPQCCommandJob_MPQCData.hpp
 *
 *  Created on: Feb 08, 2012
 *      Author: heber
 */

#ifndef MPQCCOMMANDJOB_MPQCDATA_HPP_
#define MPQCCOMMANDJOB_MPQCDATA_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/serialization/access.hpp>
#include <boost/serialization/vector.hpp>

#include <iosfwd>
#include <vector>

#include "LinearAlgebra/defs.hpp"

class MPQCCommandJob;
class MPQCCommandJobTest;
class MPQCDataTest;

/** Internal class that holds the data and can be serialized.
 *
 */
class MPQCData {
  //!> allow MPQCCommandJob access to member variables directly
  friend class MPQCCommandJob;
  //!> grant MPQCCommandJob's unit test access
  friend class MPQCCommandJobTest;
  //!> grant unit test access
  friend class MPQCDataTest;
  //!> grant access to output stream operator
  friend std::ostream & operator<<(std::ostream &ost, const MPQCData &data);
public:
  MPQCData();
  ~MPQCData();

  bool operator==(const MPQCData &other) const;

  bool operator!=(const MPQCData &other) const {
    return !(*this == other);
  }

  typedef std::vector<double> vector_type;

  double energy;
  std::vector< vector_type  > forces;

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & energy;
    ar & forces;
  }
};

std::ostream & operator<<(std::ostream &ost, const MPQCData &data);

#endif /* MPQCCOMMANDJOB_MPQCDATA_HPP_ */
