/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MPQCCommandJob_MPQCData.cpp
 *
 *  Created on: Feb 08, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "MPQCCommandJob_MPQCData.hpp"

#include <iostream>
#include <limits>

#include "CodePatterns/Log.hpp"

/** Constructor for class MPQCData.
 *
 */
MPQCData::MPQCData() :
    energy(0.)
{}

/** Destructor for class MPQCData.
 *
 */
MPQCData::~MPQCData()
{}

/** Comparator for class MPQCData.
 *
 */
bool MPQCData::operator==(const MPQCData &other) const
{
  if (fabs(energy - other.energy) > std::numeric_limits<double>::epsilon()) {
    LOG(1, "INFO: Energy's in MPQCData differ: "
        << energy << " != " << other.energy << ".");
    return false;
  }
  if (forces.size() != other.forces.size()) {
    LOG(1, "INFO: Forces's in MPQCData differ in size: "
        << forces.size() << " != " << other.forces.size() << ".");
    return false;
  }
  for (size_t i = 0; i < forces.size(); ++i)
    for (size_t index = 0; index < NDIM; ++index)
      if (fabs(forces[i][index] - other.forces[i][index]) > std::numeric_limits<double>::epsilon()) {
        LOG(1, "INFO: " << index << "th component of force of particle "
            << i << " in MPQCData differ: " << forces[i][index]
            << " != " << other.forces[i][index] << ".");
        return false;
      }
  return true;
}

std::ostream & operator<<(std::ostream &ost, const MPQCData &data)
{
  ost << "Energy: " << data.energy << "\t";
  ost << "Forces: " << data.forces;
  return ost;
}
