/*
 * TextWindow.cpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

#include "TextUI/TextWindow.hpp"

#include <boost/bind.hpp>


// TODO: When done with refactoring most of these wont be needed anymore
#include "analysis_correlation.hpp"
#include "atom.hpp"
#include "bond.hpp"
#include "bondgraph.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "element.hpp"
#include "ellipsoid.hpp"
#include "helpers.hpp"
#include "leastsquaremin.hpp"
#include "linkedcell.hpp"
#include "log.hpp"
#include "memoryusageobserver.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "World.hpp"

#include "Legacy/oldmenu.hpp"

#include "Menu/Menu.hpp"
#include "Menu/TextMenu.hpp"
#include "Menu/ActionMenuItem.hpp"
#include "Menu/SeperatorItem.hpp"
#include "Menu/DisplayMenuItem.hpp"
#include "Menu/SubMenuItem.hpp"
#include "TextUI/TextStatusIndicator.hpp"
#include "Actions/MethodAction.hpp"
#include "Actions/MoleculeAction/ChangeNameAction.hpp"
#include "Actions/ErrorAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Views/StreamStringView.hpp"
#include "Views/MethodStringView.hpp"

#include <iostream>

using namespace std;

// TODO: see what code can be moved to a base class for Graphic and Text Windows
TextWindow::TextWindow()
{
  MoleculeListClass *molecules = World::getInstance().getMolecules();
  config *configuration = World::getInstance().getConfig();
  periodentafel *periode = World::getInstance().getPeriode();
  char *ConfigFileName = NULL;
  old_menu = new oldmenu;

  // build the main menu
  main_menu = new TextMenu(Log() << Verbose(0), "Main Menu");

  moleculeView = new StreamStringView(boost::bind(&MoleculeListClass::Enumerate,molecules,_1));
  new DisplayMenuItem(main_menu,moleculeView,"Molecule List");

  new SeperatorItem(main_menu);

  Action* undoAction = ActionRegistry::getInstance().getActionByName("Undo");
  new ActionMenuItem('u',"Undo last operation",main_menu,undoAction);

  Action* redoAction = ActionRegistry::getInstance().getActionByName("Redo");
  new ActionMenuItem('r',"Redo last operation",main_menu,redoAction);

  new SeperatorItem(main_menu);

  Action *setMoleculeAction = new MethodAction("setMoleculeAction",boost::bind(&MoleculeListClass::flipChosen,molecules));
  new ActionMenuItem('a',"set molecule (in)active",main_menu,setMoleculeAction);

  TextMenu *editMoleculesMenu = new TextMenu(Log() << Verbose(0), "Edit Molecules");
  new SubMenuItem('e',"edit molecules (load, parse, save)",main_menu,editMoleculesMenu);

  Action *manipulateMoleculeAction = new MethodAction("manipulateMoleculeAction",boost::bind(&oldmenu::ManipulateMolecules,old_menu,periode, molecules, configuration));
  new ActionMenuItem('g',"globally manipulate atoms in molecule",main_menu,manipulateMoleculeAction);

  Action *mergeMoleculeAction = new MethodAction("mergeMoleculeAction",boost::bind(&oldmenu::MergeMolecules,old_menu,periode, molecules));
  new ActionMenuItem('M',"Merge molecules",main_menu,mergeMoleculeAction);

  Action *manipulateAtomsAction = new MethodAction("manipulateAtomsAction",boost::bind(&oldmenu::ManipulateAtoms,old_menu,periode, molecules, configuration));
  new ActionMenuItem('m',"manipulate atoms",main_menu,manipulateAtomsAction);

  new SeperatorItem(main_menu);

  Action *editConfigAction = new MethodAction("editConfigAction",boost::bind(&config::Edit,configuration));
  new ActionMenuItem('c',"edit the current configuration",main_menu,editConfigAction);

  new SeperatorItem(main_menu);

  Action *saveConfigAction = new MethodAction("saveConfigAction",boost::bind(&config::SaveAll,configuration, ConfigFileName, periode, molecules));
  new ActionMenuItem('s',"save current setup to config file",main_menu,saveConfigAction);

  Action *doTestAction = new MethodAction("doTestAction",boost::bind(&oldmenu::testroutine,old_menu,molecules));
  new ActionMenuItem('T',"call the current test routine",main_menu,doTestAction);

  quitAction = new MethodAction("quitAction",boost::bind(&TextMenu::doQuit,main_menu),false);
  new ActionMenuItem('q',"quit",main_menu,quitAction);

  // call all functions used to build the submenus

  populateEditMoleculesMenu(editMoleculesMenu);

  Action *returnFromEditMoleculeAction = new TextMenu::LeaveAction(editMoleculesMenu);
  MenuItem *returnItem = new ActionMenuItem('q',"return to Main menu",editMoleculesMenu,returnFromEditMoleculeAction);

  editMoleculesMenu->addDefault(returnItem);

  // Add status indicators etc...

  statusIndicator = new TextStatusIndicator();
}

TextWindow::~TextWindow()
{
  delete old_menu;
  delete quitAction;
  delete moleculeView;
  delete statusIndicator;
  delete main_menu;
}

void TextWindow::display() {
  main_menu->display();
}

void TextWindow::populateEditMoleculesMenu(Menu* editMoleculesMenu)
{
  MoleculeListClass *molecules = World::getInstance().getMolecules();
  periodentafel *periode = World::getInstance().getPeriode();

  // build the EditMoleculesMenu
  Action *createMoleculeAction = new MethodAction("createMoleculeAction",boost::bind(&MoleculeListClass::createNewMolecule,molecules,periode));
  new ActionMenuItem('c',"create new molecule",editMoleculesMenu,createMoleculeAction);

  Action *loadMoleculeAction = new MethodAction("loadMoleculeAction",boost::bind(&MoleculeListClass::loadFromXYZ,molecules,periode));
  new ActionMenuItem('l',"load molecule from xyz file",editMoleculesMenu,loadMoleculeAction);

  Action *changeFilenameAction = new MoleculeChangeNameAction();
  new ActionMenuItem('n',"change molecule's name",editMoleculesMenu,changeFilenameAction);

  Action *giveFilenameAction = new MethodAction("giveFilenameAction",boost::bind(&MoleculeListClass::setMoleculeFilename,molecules));
  new ActionMenuItem('N',"give molecules filename",editMoleculesMenu,giveFilenameAction);

  Action *parseAtomsAction = new MethodAction("parseAtomsAction",boost::bind(&MoleculeListClass::parseXYZIntoMolecule,molecules));
  new ActionMenuItem('p',"parse atoms in xyz file into molecule",editMoleculesMenu,parseAtomsAction);

  Action *eraseMoleculeAction = new MethodAction("eraseMoleculeAction",boost::bind(&MoleculeListClass::eraseMolecule,molecules));
  new ActionMenuItem('r',"remove a molecule",editMoleculesMenu,eraseMoleculeAction);

}
