/*
 * ParserTremoloUnitTest.hpp
 *
 *  Created on: Mar 3, 2010
 *      Author: metzler
 */
#ifndef PARSERTREMOLOUNITTEST_HPP_
#define PARSERTREMOLOUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>
#include <string>

class ParserTremoloUnitTest :  public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( ParserTremoloUnitTest ) ;
  CPPUNIT_TEST ( readTremoloPreliminaryCommentsTest );
  CPPUNIT_TEST ( readTremoloCoordinatesTest );
  CPPUNIT_TEST ( readTremoloVelocityTest );
  CPPUNIT_TEST ( readTremoloNeighborInformationTest );
  CPPUNIT_TEST ( readAndWriteTremoloImprDataInformationTest );
  CPPUNIT_TEST ( readAndWriteTremoloTorsionInformationTest );
  CPPUNIT_TEST ( writeTremoloTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void readTremoloPreliminaryCommentsTest();
  void readTremoloCoordinatesTest();
  void readTremoloVelocityTest();
  void readTremoloNeighborInformationTest();
  void readAndWriteTremoloImprDataInformationTest();
  void readAndWriteTremoloTorsionInformationTest();
  void writeTremoloTest();
};

#endif /* PARSERTREMOLOUNITTEST_HPP_ */
