/*
 * CommandLineParser.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include <boost/program_options.hpp>
#include <fstream>
#include <iostream>
#include <map>

#include "Patterns/Singleton_impl.hpp"
#include "CommandLineParser.hpp"
#include "log.hpp"
#include "verbose.hpp"

using namespace std;

/** Constructor of class CommandLineParser.
 *
 */
CommandLineParser::CommandLineParser() :
  generic("Generic options"),
  config("Configuration"),
  hidden("Hidden options"),
  visible("Allowed options")
{}

/** Destructor of class CommandLineParser.
 *
 */
CommandLineParser::~CommandLineParser()
{}

/** Parses the command line arguments.
 * Calls program_options::store() and program_options::notify()
 */
void CommandLineParser::Parse()
{
  po::store(po::command_line_parser(argc,argv).options(cmdline_options).options(visible).run(), vm);
  ifstream input;
  input.open("example.cfg");
  if (!input.fail())
    po::store(po::parse_config_file(input, config_file_options), vm);
  input.close();
  po::notify(vm);
}

/** Scan the argument list for -a or --arguments and store their order for later use.
 * \param &ShortFormToActionMap e.g. gives "help" for "h"
 */
void CommandLineParser::scanforSequenceOfArguments(map <std::string, std::string> &ShortFormToActionMap)
{
  // go through all arguments
  for (int i=1;i<argc;i++) {
    (cout << Verbose(1) << "Checking on " << argv[i] << endl);
    // check whether they begin with - or -- and check that next letter is not numeric, if so insert
    if (argv[i][0] == '-') {
      (cout << Verbose(1) << "Possible argument: " << argv[i] << endl);
      if (argv[i][1] == '-') {
        (cout << Verbose(1) << "Putting " << argv[i] << " into the sequence." << endl);
        SequenceOfActions.push_back(&(argv[i][2]));
      } else if (((argv[i][1] < '0') || (argv[i][1] > '9')) && ((argv[i][1] != '.'))) {
        map <std::string, std::string>::iterator iter = ShortFormToActionMap.find(&(argv[i][1]));
        if (iter != ShortFormToActionMap.end()) {
          (cout << Verbose(1) << "Putting " << iter->second << " for " << iter->first << " into the sequence." << endl);
          SequenceOfActions.push_back(iter->second);
        }
      }
    }
  }
}


/** States whether there are command line arguments.
 * \return true - there are none, false - there is at least one command line argument
 */
bool CommandLineParser::isEmpty()
{
  return vm.empty();
}

/** Sets the options.
 * \param _argc arg count from main()
 * \param **_argv argument array from main()
 */
void CommandLineParser::setOptions(int _argc, char **_argv)
{
  argc = _argc;
  argv = _argv;
  cmdline_options.add(generic).add(config).add(hidden);
  config_file_options.add(config).add(hidden);
  visible.add(generic).add(config);
}

/** Makes the Parser parse the command line options with current known options.
 * \param _argc arg count from main()
 * \param **_argv argument array from main()
 */
void CommandLineParser::Run(int _argc, char **_argv, map <std::string, std::string> &ShortFormToActionMap)
{
  setOptions(_argc,_argv);
  Parse();
  scanforSequenceOfArguments(ShortFormToActionMap);
}

CONSTRUCT_SINGLETON(CommandLineParser)
