/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SaveTemperatureAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "Atom/AtomSet.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Dynamics/OutputTemperature.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

#include "Actions/MoleculeAction/SaveTemperatureAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SaveTemperatureAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeSaveTemperatureAction::performCall() {
  LOG(1, "Storing temperatures in " << params.temperaturefile.get() << ".");
  ofstream output;
  output.open(params.temperaturefile.get().string().c_str(), ios::trunc);
  AtomSetMixin<std::vector<atom *> > set(World::getInstance().getSelectedAtoms());
  const size_t MDSteps = set.getMaxTrajectorySize();
  OutputTemperature<std::vector<atom *> > writer(set);
  if (output.fail() || !writer((ofstream * const) &output, 0, MDSteps))
    LOG(2, "File could not be written.");
  else
    LOG(2, "File stored.");
  output.close();
  return Action::success;
}

ActionState::ptr MoleculeSaveTemperatureAction::performUndo(ActionState::ptr _state) {
//  MoleculeSaveTemperatureState *state = assert_cast<MoleculeSaveTemperatureState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

ActionState::ptr MoleculeSaveTemperatureAction::performRedo(ActionState::ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveTemperatureAction::canUndo() {
  return false;
}

bool MoleculeSaveTemperatureAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
