/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SaveSelectedMoleculesAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/FormatParserStorage.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "SaveSelectedMoleculesAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SaveSelectedMoleculesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeSaveSelectedMoleculesAction::performCall() {
  LOG(1, "Storing selected molecules to file " << params.filename.get() << ".");

  // extract suffix
  std::string FilenameSuffix;
  std::string FilenamePrefix;
  if (params.filename.get().has_filename()) {
    // get suffix
      FilenameSuffix = params.filename.get().extension().string().substr(1); // remove the prefixed "."
      FilenamePrefix = params.filename.get().stem().string();
  } else {
    ELOG(1, "Output file does not have a suffix, cannot recognize format.");
    return Action::failure;
  }

  // store file
  // parse the file
  boost::filesystem::ofstream output;
  output.open(params.filename.get());
  if (!output.fail()) {
    FormatParserStorage::getInstance().saveSelectedMolecules(output, FilenameSuffix);
  } else {
    ELOG(1, "Could not open file " << params.filename.get() << ".");
  }
  output.close();

  return Action::success;
}

ActionState::ptr MoleculeSaveSelectedMoleculesAction::performUndo(ActionState::ptr _state) {
//  ParserSaveXyzState *state = assert_cast<ParserSaveXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return ActionState::ptr(new ParserSaveXyzState(state->mol,newName));
}

ActionState::ptr MoleculeSaveSelectedMoleculesAction::performRedo(ActionState::ptr _state){
  return Action::failure;
//  // Undo and redo have to do the same for this action
//  return performUndo(_state);
}

bool MoleculeSaveSelectedMoleculesAction::canUndo() {
  return false;
}

bool MoleculeSaveSelectedMoleculesAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
