/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SaveBondsAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <fstream>
#include <string>

#include "CodePatterns/Log.hpp"
#include "Graph/BondGraph.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include "Actions/MoleculeAction/SaveBondsAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SaveBondsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeSaveBondsAction::performCall() {
  molecule *mol = NULL;

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    LOG(0, "Storing bonds to path " << params.bondsfile.get() << ".");
    // TODO: sollte stream, nicht filenamen direkt nutzen, besser fuer unit tests
    mol->StoreBondsToFile(params.bondsfile.get().leaf().string(), params.bondsfile.get().branch_path().string());
  }
  return Action::success;
}

ActionState::ptr MoleculeSaveBondsAction::performUndo(ActionState::ptr _state) {
//  MoleculeSaveBondsState *state = assert_cast<MoleculeSaveBondsState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

ActionState::ptr MoleculeSaveBondsAction::performRedo(ActionState::ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveBondsAction::canUndo() {
  return false;
}

bool MoleculeSaveBondsAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
