/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RotateToPrincipalAxisSystemAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Line.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Element/element.hpp"
#include "molecule.hpp"

#include <iostream>
#include <fstream>
#include <string>

#include "Actions/MoleculeAction/RotateToPrincipalAxisSystemAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "RotateToPrincipalAxisSystemAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeRotateToPrincipalAxisSystemAction::performCall() {
  molecule *mol = NULL;

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    LOG(0, "Converting to prinicipal axis system.");

    RealSpaceMatrix InertiaTensor = mol->getInertiaTensor();

    mol->RotateToPrincipalAxisSystem(params.Axis.get());

    // summing anew for debugging (resulting matrix has to be diagonal!)
    InertiaTensor = mol->getInertiaTensor();
  }
  return Action::success;
}

ActionState::ptr MoleculeRotateToPrincipalAxisSystemAction::performUndo(ActionState::ptr _state) {
//  MoleculeRotateToPrincipalAxisSystemState *state = assert_cast<MoleculeRotateToPrincipalAxisSystemState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

ActionState::ptr MoleculeRotateToPrincipalAxisSystemAction::performRedo(ActionState::ptr _state){
  return Action::failure;
}

bool MoleculeRotateToPrincipalAxisSystemAction::canUndo() {
  return true;
}

bool MoleculeRotateToPrincipalAxisSystemAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
