/*
 * ShapeFactory.hpp
 *
 *  Created on: Sep 5, 2012
 *      Author: ankele
 */

#ifndef SHAPEFACTORY_HPP_
#define SHAPEFACTORY_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Singleton.hpp"
#include "LinearAlgebra/Vector.hpp"

#include "Shape.hpp"

class ShapeFactory : public Singleton<ShapeFactory>
{
  friend class Singleton<ShapeFactory>;

public:
  enum ShapeType{
    NOWHERE, EVERYWHERE, SPHERE, CUBE, CYLINDER, SHAPETYPES_MAX
  };

  ShapeType getShapeByName(const std::string &name);
  std::string getShapeName(ShapeType type);


  // setters/getters for the current state
  const double* getAngle() const { return angle; }
  void setAngle(double angleX, double angleY, double angleZ) { angle[0] = angleX; angle[1] = angleY; angle[2] = angleZ; }

  Vector getStretch() const { return stretch; }
  void setStretch(const Vector &stretch);

  Vector getTranslation() const { return translation; }
  void setTranslation(const Vector &translation) { this->translation = translation; }

  ShapeType getType() const { return type; }
  void setType(ShapeType type);

  // create a shape
  Shape produce() const;

private:
  // private constructor and destructor due to singleton
  ShapeFactory();
  virtual ~ShapeFactory();

  // name/type maps
  static const char *shapeNames[];
  typedef std::map<ShapeType, std::string> ShapeNameMap;
  ShapeNameMap shapeNameMap;
  typedef std::map<std::string,ShapeType> NameShapeMap;
  NameShapeMap nameShapeMap;

  // current state
  ShapeType type;
  Vector translation;
  Vector stretch;
  double angle[NDIM];
};

#endif /* SHAPEFACTORY_HPP_ */
