/*
 * QtStatusBar.hpp
 *
 *  Created on: Feb 17, 2010
 *      Author: crueger
 */

#ifndef QTSTATUSBAR_HPP_
#define QTSTATUSBAR_HPP_

#include <map>
#include <utility>
#include <string>
#include <QtGui/QStatusBar>

#include "Patterns/Observer.hpp"

class QLabel;
class QProgressBar;
class Process;
class QBoxLayout;

class QtStatusBar : public QStatusBar, public Observer
{
  Q_OBJECT

  struct progressIndicator{
    progressIndicator(std::string);
    ~progressIndicator();
    QLabel *label;
    QProgressBar *bar;
    QBoxLayout *layout;
    QWidget *container;
  };
public:
  QtStatusBar(QWidget *parent=0);
  virtual ~QtStatusBar();

  void update(Observable *subject);
  void subjectKilled(Observable *subject);

private:
  void redrawStatus();
  void redrawProcess(Process *proc);

  int atomCount;
  int moleculeCount;

  QLabel *statusLabel;
  QWidget *parent;
  std::map<Process*,progressIndicator*> progressBars;
  Process* activeProcess;
};

#endif /* QTSTATUSBAR_HPP_ */
