/*
 * MoleculeView.hpp
 *
 *  Created on: Mar 4, 2010
 *      Author: crueger
 */

#ifndef MOLECULEVIEW_HPP_
#define MOLECULEVIEW_HPP_

#include <string>
#include <QtGui/QTabWidget>
#include "Patterns/Observer.hpp"

class molecule;

// Forwarding of the Tab-Pages
class QTAllMoleculePage;
class QTMoleculePage;

class QtMoleculeView : public QTabWidget
{
  Q_OBJECT
public:
  QtMoleculeView();
  virtual ~QtMoleculeView();

public slots:
  void moleculeSelected(molecule *);
  void moleculeUnSelected(molecule *);

  void nameChanged(QTMoleculePage *page, std::string name);

signals:
  void addMolecule(molecule *);
  void removeMolecule(molecule *);


private:
  QTAllMoleculePage *allPage; //!< contained widget to cary information of all selected molecules
  std::map<molecule*,QTMoleculePage *> pages;//!< contained widget to cary information on a specific molecule
};

/**
 * Widget to display the tab page for all selected molecules
 */
class QTAllMoleculePage : public QWidget, public Observer {
  Q_OBJECT
public:
  QTAllMoleculePage();
  void update(Observable *subject);
  void subjectKilled(Observable *subject);
public slots:
  void addMolecule(molecule *mol);
  void removeMolecule(molecule *mol);
};

/**
 * Widget to display the tab page for a single molecule
 */
class QTMoleculePage : public QWidget,  public Observer {
  Q_OBJECT
public:
  QTMoleculePage(molecule *_mol,std::string _name);
  virtual ~QTMoleculePage();

  void update(Observable *subject);
  void subjectKilled(Observable *subject);

signals:
  void nameChanged(QTMoleculePage*,std::string);

private:
  molecule *mol;
  std::string name;
};
#endif /* MOLECULEVIEW_HPP_ */
