/*
 * QtMainWindow.hpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#ifndef QTMAINWINDOW_HPP_
#define QTMAINWINDOW_HPP_

#include "UIElements/MainWindow.hpp"
#include <QtGui/QMainWindow>

#include <set>

class QtWorldView;
class StringView;
class QtMenu;
class GLMoleculeView;
class QtMoleculeView;
class QtStatusBar;

class QtMainWindow : public QMainWindow, public MainWindow
{
  Q_OBJECT

public:
  QtMainWindow(QApplication *_theApp);
  virtual ~QtMainWindow();

  virtual void display();

  char getSuitableShortForm(std::set <char> &ShortcutList, const std::string name) const;
  void populateMenu(QtMenu* Menu, const  std::string &MenuName);

private:
  // All kinds of QTStuff used in this window
  QApplication *theApp;
  QtWorldView *worldDisplay;
  QtMenu *editMoleculesMenu;
  GLMoleculeView *molecule3dDisplay;
  QtMoleculeView *moleculeDisplay;
  QtStatusBar *statusBar;
  QMenuBar *MenuBar;

};

#endif /* QTMAINWINDOW_HPP_ */
