/*
 * QtMenu.hpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

#ifndef QTMENU_HPP_
#define QTMENU_HPP_

#include <list>

#include <QtGui/QMenu>
#include <QtCore/QObject>

#include "Menu/Menu.hpp"

class QtMenuPipe;

class QtMenu : public QMenu, public Menu
{
  Q_OBJECT

public:
  QtMenu(const char *);
  virtual ~QtMenu();

  virtual void addItem(MenuItem*);
  virtual void removeItem(MenuItem*);
  virtual void display();
private:
  list<QtMenuPipe*> plumbing;
};

// This handles the plumbing from QT to internal Items
// Slots from QT are redirected to internal methods.
// This way methods can be used where no QT is available
class QtMenuPipe : public QObject {
  Q_OBJECT
public:
  QtMenuPipe(MenuItem*,QAction*);
  virtual ~QtMenuPipe();
public slots:
  void called();
private:
  MenuItem *theItem;
  QAction *theAction;
};

#endif /* QTMENU_HPP_ */
