/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtMenu.cpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Menu/Qt4/QtMenu.hpp"

#include <Qt/qaction.h>

#include "Helpers/MemDebug.hpp"

#include "Menu/MenuItem.hpp"

QtMenu::QtMenu(const char * _title) :
  QMenu(_title)
{}

QtMenu::~QtMenu()
{
  // yay... Just like Mario Bros.
  for(list<QtMenuPipe*>::iterator it=plumbing.begin(); it != plumbing.end(); it++)
    delete (*it);
}

void QtMenu::addItem(MenuItem* item) {
  const string description = item->getDescription();
  QAction *action = addAction(QString(description.c_str()));
  QtMenuPipe *pipe = new QtMenuPipe(item,action);
  QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
  plumbing.push_back(pipe);
}

void QtMenu::removeItem(MenuItem* item) {
  list<QtMenuPipe*>::iterator iter;
  for(iter=plumbing.begin(); iter!=plumbing.end(); iter++){
    delete (*iter);
  }
}

void QtMenu::display() {

}

QtMenuPipe::QtMenuPipe(MenuItem *_item, QAction *_action) :
    theItem(_item), theAction(_action)
{}

QtMenuPipe::~QtMenuPipe() {
  delete theAction;
  delete theItem;
}

void QtMenuPipe::called() {
  theItem->doTrigger();
}
