/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QTMoleculeView.cpp
 *
 *  Created on: Mar 4, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Views/QT4/QTMoleculeView.hpp"

#include <iostream>

#include "Helpers/MemDebug.hpp"

#include "molecule.hpp"

using namespace std;

/***************** Basic structure for tab layout ***********/

QTMoleculeView::QTMoleculeView() :
    QTabWidget()
{
  allPage = new QTAllMoleculePage();
  addTab(allPage,QString("All Molecules"));

  connect(this,SIGNAL(addMolecule(molecule*)),allPage,SLOT(addMolecule(molecule*)));
  connect(this,SIGNAL(removeMolecule(molecule*)),allPage,SLOT(removeMolecule(molecule*)));
}

QTMoleculeView::~QTMoleculeView()
{}

void QTMoleculeView::moleculeSelected(molecule *mol){
  if(!pages.count(mol)){
    string molName = mol->GetName();
    QTMoleculePage *molPage = new QTMoleculePage(mol,molName);
    addTab(molPage,QString(molName.c_str()));
    pages[mol] = molPage;

    connect(molPage,SIGNAL(nameChanged(QTMoleculePage*,std::string)),this,SLOT(nameChanged(QTMoleculePage*,std::string)));

    emit addMolecule(mol);
  }
}

void QTMoleculeView::moleculeUnSelected(molecule *mol){
  if(pages.count(mol)){
    QTMoleculePage *molPage = pages[mol];
    removeTab(indexOf(molPage));
    pages.erase(mol);
    delete molPage;
    emit removeMolecule(mol);
  }
}

void QTMoleculeView::nameChanged(QTMoleculePage *page, std::string name){
  setTabText(indexOf(page),QString(name.c_str()));
}

/************************ Tab for all Molecules ********************/

QTAllMoleculePage::QTAllMoleculePage() :
  Observer("QTAllMoleculePage")
{}

void QTAllMoleculePage::addMolecule(molecule *mol){}

void QTAllMoleculePage::removeMolecule(molecule *mol){}

void QTAllMoleculePage::update(Observable *subject){}

void QTAllMoleculePage::subjectKilled(Observable *subject){}

/************************ Tab for single Molecules *****************/

QTMoleculePage::QTMoleculePage(molecule *_mol, string _name) :
    Observer("QTMoleculePage"),
    mol(_mol), name(_name)
{
  mol->signOn(this);
}

QTMoleculePage::~QTMoleculePage(){
  mol->signOff(this);
}

void QTMoleculePage::update(Observable *subject){
  if(name != mol->GetName()){
    name = mol->GetName();
    emit nameChanged(this,name);
  }
}

void QTMoleculePage::subjectKilled(Observable *subject){}
