/*
 * QSeisPlotPage.hpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

#ifndef QSEISPLOTPAGE_HPP
#define QSEISPLOTPAGE_HPP

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QWidget>

class QSeisPlot;
class QListWidgetItem;
class QListWidget;

/**
 * \class QSeisPlotPage
 *
 * This class is derived from QWidget and provides
 * the GUI elements for a single plot tab.
 **/
class QSeisPlotPage : public QWidget
{
    Q_OBJECT
public:
    explicit QSeisPlotPage(QString type, QWidget *parent = 0);
    ~QSeisPlotPage();
    QString plotType;
    QListWidget *curveList;
    QSeisPlot *plot;
    std::string getName();
    void resetPlot();

private slots:
    void listItemChanged(QListWidgetItem *item);

signals:

public slots:
    void addCurve(std::string name);
    void removeCurve(std::string name);
    void updateCurve(std::string name);

};

#endif // QSEISPLOTPAGE_HPP
