/*
 * QSeisPlotCurve.hpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

#ifndef QSEISPLOTCURVE_HPP
#define QSEISPLOTCURVE_HPP

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwt_global.h>
#include <qwt_plot_curve.h>
#include <QtCore/QObject>
#include <string>

/**
 * \class QSeisPlotCurve
 *
 * This class is notified of changes by
 * its corresponding QSeisData object.
 *
 * It fetches automatically a free curve colour
 * for the plot is attached to (and "frees" the
 * colour on detach).
 *
 * When the curve is attached and only the column
 * number without data is available (due to preparse only),
 * the class emits the dataRequested() signal to fetch the
 * full data set. The "empty" curve is still directly
 * attached to the plot, but gets autotically updated
 * when the data has been completely processed.
 * (This way the user interface does not get blocked.)
 **/

class QSeisPlot;

class QSeisPlotCurve : public QObject, public QwtPlotCurve
{
    Q_OBJECT

public:
    QSeisPlotCurve(QString name, QString dataType, bool preparsed = true);
    ~QSeisPlotCurve();
    std::string getName();
    QString type;
    void attach(QSeisPlot *plot);
    void detach();
    QString getDisplayName() { return QString::fromStdString(getName()); }
    std::string color;

public slots:
    void updateCurve(QwtData *newData);
    void markAsOutOfDate();

private:
    QString intName;
    bool onlyPreparsed;
    bool upToDate;

signals:
    void dataRequested();
};

#endif // QSEISPLOTCURVE_HPP
