/*
 * QSeisPlotCurve.cpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/Plotting/QSeisPlotCurve.hpp"
#include "UIElements/Views/Qt4/Plotting/QSeisPlot.hpp"

// have this after(!) all Qt includes
#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Assert.hpp"


QSeisPlotCurve::QSeisPlotCurve(QString name, QString dataType, bool preparsed) :
        type(dataType), intName(name), onlyPreparsed(preparsed), upToDate(true)
{}

QSeisPlotCurve::~QSeisPlotCurve()
{
    detach();
}

std::string QSeisPlotCurve::getName()
{
    return intName.toStdString();
}

void QSeisPlotCurve::updateCurve(QwtData *newData)
{
    setTitle(intName.right(intName.length() - intName.lastIndexOf('/') - 1));
    setData(*newData);
    upToDate = true;
    if (plot() != NULL)
        plot()->replot();
}

void QSeisPlotCurve::attach(QSeisPlot *plot)
{
    //check if already all data is present or if we have to request it
    if (onlyPreparsed || !upToDate)
    {
        onlyPreparsed = false;
        emit dataRequested();
    }
    setPen(QPen(plot->getCurveColor(color)));
    QwtPlotCurve::attach((QwtPlot *)plot);
}

void QSeisPlotCurve::detach()
{
    if (plot() == NULL)
        return;

    ((QSeisPlot *)plot())->freeCurveColor(pen().color());
    QwtPlotCurve::detach();
}

void QSeisPlotCurve::markAsOutOfDate()
{
    upToDate = false;
    if (plot() != NULL)
        emit dataRequested();
}
