/*
 * QSeisPlot.hpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

#ifndef QSEISPLOT_HPP
#define QSEISPLOT_HPP

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//uncomment the define below to use the QwtPlotPanner instead
//of my manual implementation
//#define QWTPANNER

#include <qwt_global.h>
#include <qwt_plot.h>
#ifdef QWTPANNER
#include <qwt_plot_panner.h>
#endif
#include "UIElements/Views/Qt4/Plotting/QScrollZoomer/ScrollZoomer.hpp"
#include <QtGui/QMouseEvent>
#include <QtCore/QList>
#include <map>
#include <string>

/**
 * \class QSeisPlot
 *
 * This class is derived from QwtPlot.
 * It implements the ScrollZoomer class
 * from the Qwt Realtime example.
 * The zoomer implementation has some flaws
 * because the zoomer class needs to know
 * what QRectF is the "unzoomed" view.
 * Not all actions where this rect is changed
 * are correctly handled at the moment!
 *
 * It is possible to pan around the plot canvas
 * using the middle mouse button.
 * The original QwtPanner implementation (available
 * by defining "QWTPANNER") is less CPU intensive
 * but does not pan while dragging around.
 *
 * This class also holds a QList of available
 * curve colours. The list is initialised in the
 * constructor. The QSeisPlotCurve class is
 * implemented to fetch a colour from plot it is
 * about to get attached to and "free the colour"
 * if it gets detached.
 **/

class QSeisPlot : public QwtPlot
{
    Q_OBJECT

public:
    QSeisPlot(QWidget *parent,QString type);
    ~QSeisPlot();
    void loadSettingsFromXML(QString fileName);
    QColor getCurveColor(std::string);
    void freeCurveColor(QColor color);

private:
    QList<QColor> availableColors;
    ScrollZoomer *zoomer;
    std::map<std::string,QColor> color_map;
#ifdef QWTPANNER
    QwtPlotPanner *panner;
#else
    QPointF startPan;
    bool panning;
    void mouseMoveEvent(QMouseEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
#endif

signals:

public slots:
    void resetPlot();
    void resetZoomer();
};

#endif // QSEISPLOT_HPP
