/*
 * QSeisPageRegistry.cpp
 *
 *  Created on: Mar 14, 2011
 *      Author: landvogt
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/Plotting/QSeisPageRegistry.hpp"
#include "UIElements/Views/Qt4/Plotting/QSeisPlotPage.hpp"

// have this after(!) all Qt includes
#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Registry_impl.hpp"
#include "CodePatterns/Singleton_impl.hpp"


QSeisPageRegistry::QSeisPageRegistry()
{

}

QSeisPageRegistry::~QSeisPageRegistry()
{

}

void QSeisPageRegistry::cleanup()
{
    for (std::map<const std::string,QSeisPlotPage*>::iterator iter = getBeginIter(); iter != getEndIter(); ++iter)
        emit pageDeleted(QString::fromStdString(iter->first));
    Registry<QSeisPlotPage>::cleanup();
}

QSeisPlotPage* QSeisPageRegistry::getByName(const std::string name)
{
    if (!isPresentByName(name))
    {
        //create new plot tab
        QSeisPlotPage *new_page = new QSeisPlotPage(QString::fromStdString(name));
        registerInstance(new_page);
        emit pageCreated((QWidget *)new_page, QString::fromStdString(name));
    }
    return Registry<QSeisPlotPage>::getByName(name);
}

void QSeisPageRegistry::deleteByName(const std::string name)
{
    if (!isPresentByName(name))
        return;

    QSeisPlotPage *page = Registry<QSeisPlotPage>::getByName(name);
    unregisterInstance(page);
    QString delName = page->plotType;
    delete page;
    emit pageDeleted(delName);
}

void QSeisPageRegistry::registerInstance(QSeisPlotPage *instance)
{
    Registry<QSeisPlotPage>::registerInstance(instance);
}

void QSeisPageRegistry::unregisterInstance(QSeisPlotPage *instance)
{
    Registry<QSeisPlotPage>::unregisterInstance(instance);
}

void QSeisPageRegistry::addCurve(std::string name, QString dataType)
{
    QSeisPlotPage *page = getByName(dataType.toStdString());
    page->addCurve(name);
}

void QSeisPageRegistry::removeCurve(std::string name, QString dataType)
{
    QSeisPlotPage *page = getByName(dataType.toStdString());
    page->removeCurve(name);
}

void QSeisPageRegistry::updateCurve(std::string name, QString dataType)
{
    QSeisPlotPage *page = getByName(dataType.toStdString());
    page->updateCurve(name);
}

void QSeisPageRegistry::resetPlotView(QString dataType)
{
    QSeisPlotPage *page = getByName(dataType.toStdString());
    page->resetPlot();
}

CONSTRUCT_SINGLETON(QSeisPageRegistry)
CONSTRUCT_REGISTRY(QSeisPlotPage)
