/*
 * QSeisData.hpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

#ifndef QSEISDATA_HPP
#define QSEISDATA_HPP

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwt_global.h>
#include <qwt_data.h>
#include <QtCore/QObject>
#include <vector>

/**
 * \class QSeisData
 *
 * This class gets its data from the QSeisParser
 * class through the updateData() slot.
 * The class itself emits a signal if its data
 * changes which should call the corresponding update
 * slots of the child QSeisPlotCurve objects.
 *
 * This class passes the request to fully parse a
 * only through from its child QSeisPlotCurve class
 * to its Corresponding QSeisParser class.
 *
 * This objects gets destroyed together with its parent
 * object (QSeisPlotCurve).
 *
 * <the right place to implement display
 *  around average etc.>
 **/

class QSeisParser;

class QSeisData : public QObject, public QwtData
{
    Q_OBJECT

public:
    QSeisData(QString name, quint32 columnNo);
    QSeisData(std::vector<double> xValues, std::vector<double> yValues, QString name);
    ~QSeisData();
    double x(size_t i) const;
    double y(size_t i) const;
    QSeisData *copy() const;
    size_t size() const;

private:
    QString intName;
    std::vector<double> xData;
    std::vector<double> yData;
    quint32 columnNumber;
    void createCurve();

public slots:
    void updateData(const std::vector< std::vector<double> > &newData);

signals:
    void dataChanged(QwtData *newData);
    void dataRequested();
    void dataOutOfDate();
};

#endif // QSEISDATA_HPP
