/*
 * QSeisCurveRegistry.cpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/Plotting/QSeisCurveRegistry.hpp"
#include "UIElements/Views/Qt4/Plotting/QSeisPlotCurve.hpp"

// have this after(!) all Qt includes
#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Registry_impl.hpp"
#include "CodePatterns/Singleton_impl.hpp"

#include <iostream>

QSeisCurveRegistry::QSeisCurveRegistry()
{
}

QSeisCurveRegistry::~QSeisCurveRegistry()
{}

void QSeisCurveRegistry::registerInstance(QSeisPlotCurve *instance)
{
    Registry<QSeisPlotCurve>::registerInstance(instance);
    emit curveAdded(instance->getName(), instance->type);
}

void QSeisCurveRegistry::unregisterInstance(QSeisPlotCurve *instance)
{
    Registry<QSeisPlotCurve>::unregisterInstance(instance);
    emit curveRemoved(instance->getName(), instance->type);
}

void QSeisCurveRegistry::resetRegistry()
{
	for (std::map<const std::string,QSeisPlotCurve*>::iterator iter = getBeginIter(); iter != getEndIter(); ++iter)
		emit curveRemoved(iter->first, iter->second->type);
		Registry<QSeisPlotCurve>::cleanup();
}


CONSTRUCT_SINGLETON(QSeisCurveRegistry)
CONSTRUCT_REGISTRY(QSeisPlotCurve)
