/*
 * LinkedCell_ControllerUnitTest.hpp
 *
 *  Created on: Nov 29, 2011
 *      Author: heber
 */

#ifndef LINKEDCELL_CONTROLLERUNITTEST_HPP_
#define LINKEDCELL_CONTROLLERUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include <vector>

#include "LinkedCell/PointCloudAdaptor.hpp"

class atom;
class Box;
class RealSpaceMatrix;
namespace LinkedCell {
  class LinkedCellController;
}

/********************************************** Test classes **************************************/

class LinkedCell_ControllerTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( LinkedCell_ControllerTest) ;
    CPPUNIT_TEST ( thresholdTest );
    CPPUNIT_TEST ( getHeuristicRangeTest );
    CPPUNIT_TEST ( getView_SameViewTest );
    CPPUNIT_TEST ( getView_DifferentViewTest );
    CPPUNIT_TEST ( getView_InRangeViewTest );
    CPPUNIT_TEST ( getView_OutOfRangeViewTest );
    CPPUNIT_TEST ( getView_LowerThresholdViewTest );
    CPPUNIT_TEST ( getView_UpperThresholdViewTest );
    CPPUNIT_TEST ( updateBoxTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();

      void thresholdTest();
      void getHeuristicRangeTest();
      void getView_SameViewTest();
      void getView_DifferentViewTest();
      void getView_InRangeViewTest();
      void getView_OutOfRangeViewTest();
      void getView_LowerThresholdViewTest();
      void getView_UpperThresholdViewTest();
      void updateBoxTest();

private:
      Box *domain;
      RealSpaceMatrix *BoxM;
      std::vector<atom *> emptyvector;
      PointCloudAdaptor< std::vector<atom *> > *emptyset;
      LinkedCell::LinkedCell_Controller *controller;
};


#endif /* LINKEDCELL_CONTROLLERUNITTEST_HPP_ */
