/*
 * LinkedCell_Controller.hpp
 *
 *  Created on: Nov 15, 2011
 *      Author: heber
 */

#ifndef LINKEDCELL_CONTROLLER_HPP_
#define LINKEDCELL_CONTROLLER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "CodePatterns/Observer/Observer.hpp"
#include "CodePatterns/Range.hpp"
#include "LinkedCell/LinkedCell_View.hpp"

class LinkedCell_ControllerTest;
class IPointCloud;

namespace LinkedCell {

  class LinkedCell_Model;

  /** This is the controller in the MVC ansatz for the LinkedCell structure.
   *
   * \sa linkedcell
   *
   * The Controller contains multiple models (i.e. LinkedCell instances) and he
   * takes care that the view (the interface) can give its functionality with
   * low computational complexity.
   *
   * Here, it contains multiple LinkedCell models, each with different edge
   * lengths of the inherent mesh. You request a LinkedCell instance from the
   * controller, but you basically just receive a const interface reference
   * to a present LinkedCell instance.
   *
   */
  class LinkedCell_Controller : public Observer
  {
    //!> grant unit tests access to internal parts
    friend class ::LinkedCell_ControllerTest;
  public:
    LinkedCell_Controller(const Box &_domain);
    ~LinkedCell_Controller();

    LinkedCell_View getView(const double distance, IPointCloud &set);

    void update(Observable *publisher);
    void recieveNotification(Observable *publisher, Notification_ptr notification);
    void subjectKilled(Observable *publisher);

  private:
    const LinkedCell_Model * getBestModel(const double distance) const;
    const range<double> getHeuristicRange(const double distance) const;
    void insertNewModel(const double edgelength, const LinkedCell_Model* instance);
    void updateModelsForNewBoxMatrix();

  private:
    //!> typedef for the (edge length, model) map
    typedef std::map<double, const LinkedCell_Model* > MapEdgelengthModel;

    //!> internal map of present LinkedCell_Model instances by their egde length
    MapEdgelengthModel ModelsMap;

    //!> lower threshold below which no new instances are generated.
    static double lower_threshold;

    //!> upper threshold above which no new instances are generated.
    static double upper_threshold;

    //!> internal reference to domain required for constructing LinkedCell_Model instances.
    const Box &domain;
  };

}

#endif /* LINKEDCELL_CONTROLLER_HPP_ */
