#ifndef BOUNDARY_HPP_
#define BOUNDARY_HPP_

class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;
class CandidateForTesselation;

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// STL headers
#include <map>
#include <set>
#include <deque>

#include <gsl/gsl_poly.h>

#include "linkedcell.hpp"
#include "molecules.hpp"

template <typename T> void SetEndpointsOrdered(T endpoints[2], T endpoint1, T endpoint2)
{
  if (endpoint1->Nr < endpoint2->Nr) {
    endpoints[0] = endpoint1;
    endpoints[1] = endpoint2;
  } else {
    endpoints[0] = endpoint2;
    endpoints[1] = endpoint1;
  }
};

class BoundaryPointSet {
  public:
    BoundaryPointSet();
    BoundaryPointSet(atom *Walker);
    ~BoundaryPointSet();

    void AddLine(class BoundaryLineSet *line);

    LineMap lines;
    int LinesCount;
    atom *node;
    int Nr;
};

class BoundaryLineSet {
  public:
    BoundaryLineSet();
    BoundaryLineSet(class BoundaryPointSet *Point[2], int number);
    ~BoundaryLineSet();

    void AddTriangle(class BoundaryTriangleSet *triangle);

    class BoundaryPointSet *endpoints[2];
    TriangleMap triangles;
    int TrianglesCount;
    int Nr;
};

class BoundaryTriangleSet {
  public:
    BoundaryTriangleSet();
    BoundaryTriangleSet(class BoundaryLineSet *line[3], int number);
    ~BoundaryTriangleSet();

    void GetNormalVector(Vector &NormalVector);

    class BoundaryPointSet *endpoints[3];
    class BoundaryLineSet *lines[3];
    Vector NormalVector;
    int Nr;
};


class CandidateForTesselation {
  public :
	CandidateForTesselation(atom* candidate, BoundaryLineSet* currentBaseLine, Vector OptCandidateCenter, Vector OtherOptCandidateCenter);
	~CandidateForTesselation();
	atom *point;
	BoundaryLineSet *BaseLine;
	Vector OptCenter;
	Vector OtherOptCenter;
};


class Tesselation {
  public:

    Tesselation();
    ~Tesselation();

    void TesselateOnBoundary(ofstream *out, config *configuration, molecule *mol);
    void GuessStartingTriangle(ofstream *out);
    void AddPoint(atom * Walker);
    void AddTrianglePoint(atom* Candidate, int n);
    void AddTriangleLine(class BoundaryPointSet *a, class BoundaryPointSet *b, int n);
    void AlwaysAddTriangleLine(class BoundaryPointSet *a, class BoundaryPointSet *b, int n);
    void AddTriangle();
    void Find_starting_triangle(ofstream *out, molecule* mol, const double RADIUS, LinkedCell *LC);
    bool Find_next_suitable_triangle(ofstream *out, molecule* mol, BoundaryLineSet &Line, BoundaryTriangleSet &T, const double& RADIUS, int N, const char *filename, LinkedCell *LC);
    int CheckPresenceOfTriangle(ofstream *out, atom *Candidates[3]);
    void Find_next_suitable_point_via_Angle_of_Sphere(atom* a, atom* b, atom* c, atom* Candidate, atom* Parent, int RecursionLevel, Vector *Chord, Vector *direction1, Vector *OldNormal, Vector ReferencePoint, atom*& Opt_Candidate, double *Storage, const double RADIUS, molecule* mol);

    PointMap PointsOnBoundary;
    LineMap LinesOnBoundary;
    TriangleMap TrianglesOnBoundary;
    class BoundaryPointSet *TPS[3]; //this is a Storage for pointers to triangle points, this and BPS[2] needed due to AddLine restrictions
    class BoundaryPointSet *BPS[2];
    class BoundaryLineSet *BLS[3];
    class BoundaryTriangleSet *BTS;
    int PointsOnBoundaryCount;
    int LinesOnBoundaryCount;
    int TrianglesOnBoundaryCount;
    int TriangleFilesWritten;
};


ostream & operator << (ostream &ost, BoundaryPointSet &a);
ostream & operator << (ostream &ost, BoundaryLineSet &a);
ostream & operator << (ostream &ost, BoundaryTriangleSet &a);


double VolumeOfConvexEnvelope(ofstream *out, const char *filename, config *configuration, Boundaries *BoundaryPoints, molecule *mol);
double * GetDiametersOfCluster(ofstream *out, Boundaries *BoundaryPtr, molecule *mol, bool IsAngstroem);
void PrepareClustersinWater(ofstream *out, config *configuration, molecule *mol, double ClusterVolume, double celldensity);
void Find_non_convex_border(ofstream *out, molecule* mol, class Tesselation *T, class LinkedCell *LC, const char *tempbasename, const double RADIUS);
void Find_next_suitable_point(class BoundaryTriangleSet *BaseTriangle, class BoundaryLineSet *BaseLine, atom*& OptCandidate, Vector *OptCandidateCenter, double *ShortestAngle, const double RADIUS, LinkedCell *LC);
bool Choose_preferable_third_point(atom *Candidate, atom *OptCandidate, class BoundaryLineSet *BaseLine, atom *ThirdNode, Tesselation *Tess);
bool existsIntersection(Vector point1, Vector point2, Vector point3, Vector point4);
bool sortCandidates(CandidateForTesselation* candidate1, CandidateForTesselation* candidate2);

#endif /*BOUNDARY_HPP_*/
