/*
 * ObservedValue_wCallback.hpp
 *
 *  Created on: Oct 16, 2015
 *      Author: heber
 */


#ifndef OBSERVEDVALUE_WCALLBACK_HPP_
#define OBSERVEDVALUE_WCALLBACK_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/ObservedValue.hpp"
#include "CodePatterns/Observer/Observable.hpp"

#include <string>

#include <boost/bind.hpp>
#include <boost/function.hpp>

/** We derive from ObservedValue in order to tell owning instance about
 * subjectKilled() having been called.
 */
template <class T, class id=T>
class ObservedValue_wCallback : public ObservedValue<T>
{
public:
  ObservedValue_wCallback(
      const Observable * const _owner,
      const boost::function<T()> &_recalcMethod,
      const std::string &_name,
      const T &_initialvalue,
      const Observable::channels_t &_channels,
      const boost::function<void(const id)> &_callback,
      const boost::function<const id()> &_getId) :
        ObservedValue<T>(_owner, _recalcMethod, _name, _initialvalue, _channels),
        callback(_callback),
        getId(_getId)
  {}
  virtual ~ObservedValue_wCallback()
  {}

protected:
  virtual void subjectKilled(Observable *publisher)
  {
    ObservedValue<T>::subjectKilled(publisher);
    callback(getId());
  }

private:
  //!> callback function to tell other entity about subjectKilled
  const boost::function<void(const id)> callback;
  const boost::function<const id()> getId;
};

/** Specialization of ObservedValue_wCallback for the index ObservedValue.
 *
 * The index serves as the unique identifier for the object instance whose
 * properties are monitored in ObservedValue. Hence, how to give a subjectKilled()
 * with an external getId() function? For the index the ObservedValue::get() is
 * the getId() we need to call! Hence, we may simply connect these internally
 * in this partial template specialization.
 *
 * Because atomicNumber_t, atomId_t and moleculeId_t are not unique types but
 * -- at the writing of this class -- just typedefs, we have to resort to the
 * trick with two constructors, one taking an external getId(), the other
 * routing the getId() internally by binding to ObservedValue<T>::get().
 */
template <class T>
class ObservedValue_wCallback<T,T> : public ObservedValue<T>
{
public:
  ObservedValue_wCallback(
      const Observable * const _owner,
      const boost::function<T()> &_recalcMethod,
      const std::string &_name,
      const T &_initialvalue,
      const Observable::channels_t &_channels,
      const boost::function<void(const T)> &_callback,
      const boost::function<const T()> &_getId) :
        ObservedValue<T>(_owner, _recalcMethod, _name, _initialvalue, _channels),
        callback(_callback),
        getId(_getId)
  {}
  ObservedValue_wCallback(
      const Observable * const _owner,
      const boost::function<T()> &_recalcMethod,
      const std::string &_name,
      const T &_initialvalue,
      const Observable::channels_t &_channels,
      const boost::function<void(const T)> &_callback) :
        ObservedValue<T>(_owner, _recalcMethod, _name, _initialvalue, _channels),
        callback(_callback),
        getId(boost::bind(&ObservedValue<T>::get, this))
  {}
  virtual ~ObservedValue_wCallback()
  {}

protected:
  virtual void subjectKilled(Observable *publisher)
  {
    ObservedValue<T>::subjectKilled(publisher);
    callback(getId());
  }

private:
  //!> callback function to tell other entity about subjectKilled
  const boost::function<void(const T)> callback;
  const boost::function<const T()> getId;
};

#endif /* OBSERVEDVALUE_WCALLBACK_HPP_ */
