/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SaveXyzAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/ParserAction/SaveXyzAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Parser/XyzParser.hpp"
#include "atom.hpp"
#include "molecule.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


/****** ParserSaveXyzAction *****/

//// memento to remember the state when undoing
//
//class ParserSaveXyzState : public ActionState {
//public:
//  ParserSaveXyzState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char ParserSaveXyzAction::NAME[] = "SaveXyz";

ParserSaveXyzAction::ParserSaveXyzAction() :
  Action(NAME)
{}

ParserSaveXyzAction::~ParserSaveXyzAction()
{}

void ParserSaveXyz(std::string &filename) {
  ValueStorage::getInstance().setCurrentValue(ParserSaveXyzAction::NAME, filename);
  ActionRegistry::getInstance().getActionByName(ParserSaveXyzAction::NAME)->call(Action::NonInteractive);
};

Dialog* ParserSaveXyzAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr ParserSaveXyzAction::performCall() {
  string filename;
  XyzParser parser;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  // store xyz file
  ofstream output;
  output.open(filename.c_str());
  if (!output.fail())
    parser.save(&output);
  output.close();
  return Action::failure;
}

Action::state_ptr ParserSaveXyzAction::performUndo(Action::state_ptr _state) {
//  ParserSaveXyzState *state = assert_cast<ParserSaveXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserSaveXyzState(state->mol,newName));
}

Action::state_ptr ParserSaveXyzAction::performRedo(Action::state_ptr _state){
  return Action::failure;
//  // Undo and redo have to do the same for this action
//  return performUndo(_state);
}

bool ParserSaveXyzAction::canUndo() {
  return false;
}

bool ParserSaveXyzAction::shouldUndo() {
  return false;
}

const string ParserSaveXyzAction::getName() {
  return NAME;
}
