/*
 * GlobalListOfActions.hpp
 *
 *  Created on: Sep 21, 2011
 *      Author: heber
 */

#ifndef GLOBALLISTOFACTIONS_HPP_
#define GLOBALLISTOFACTIONS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/preprocessor/seq/push_back.hpp>

// this is global list of actions valid for all cases
#define GLOBALLISTOFACTIONS_initial \
  (Redo) \
  (GraphUpdateMolecules) \
  (GraphCreateAdjacency) \
  (GraphDepthFirstSearch) \
  (GraphDestroyAdjacency) \
  (GraphSubgraphDissection) \
  (MoleculeSaveTemperature) \
  (MoleculeCopy) \
  (MoleculeSuspendInWater) \
  (MoleculeFillWithMolecule) \
  (MoleculeRotateToPrincipalAxisSystem) \
  (MoleculeSaveAdjacency) \
  (MoleculeFillVoidWithMolecule) \
  (MoleculeVerletIntegration) \
  (MoleculeChangeName) \
  (MoleculeChangeBondAngle) \
  (MoleculeRotateAroundSelfByAngle) \
  (MoleculeSaveSelectedMolecules) \
  (MoleculeSaveBonds) \
  (MoleculeStretchBond) \
  (MoleculeLinearInterpolationofTrajectories) \
  (MoleculeLoad) \
  (MoleculeBondFile) \
  (TesselationNonConvexEnvelope) \
  (TesselationConvexEnvelope) \
  (CommandElementDb) \
  (CommandVerbose) \
  (CommandWarranty) \
  (CommandVersion) \
  (CommandHelp) \
  (CommandHelpRedistribute) \
  (CommandBondLengthTable) \
  (CommandFastParsing) \
  (ParserSetTremoloAtomdata) \
  (ParserParseTremoloPotentials) \
  (ParserSaveSelectedAtomsAsExtTypes) \
  (ParserSetParserParameters) \
  (ParserSetOutputFormats) \
  (AnalysisCalculateBoundingBox) \
  (AnalysisCalculateCellVolume) \
  (AnalysisCalculateMolarMass) \
  (AnalysisDipoleAngularCorrelation) \
  (AnalysisDipoleCorrelation) \
  (AnalysisPairCorrelation) \
  (AnalysisPointCorrelation) \
  (AnalysisSurfaceCorrelation) \
  (AnalysisMolecularVolume) \
  (AnalysisPrincipalAxisSystem) \
  (CommandSetRandomNumbersEngine) \
  (CommandSetRandomNumbersDistribution) \
  (Undo) \
  (AtomSaveSelectedAtoms) \
  (AtomRotateAroundOriginByAngle) \
  (AtomChangeElement) \
  (AtomRemove) \
  (AtomTranslate) \
  (AtomAdd) \
  (BondAdd) \
  (BondRemove) \
  (WorldCenterInBox) \
  (WorldRepeatBox) \
  (WorldChangeBox) \
  (WorldCenterOnEdge) \
  (WorldSetWorldTime) \
  (WorldSetBoundaryConditions) \
  (WorldOutput) \
  (WorldOutputAs) \
  (WorldSetDefaultName) \
  (WorldScaleBox) \
  (WorldAddEmptyBoundary) \
  (WorldBoundInBox) \
  (WorldInput) \
  (SelectionNotMoleculeOfAtom) \
  (SelectionNotAllMolecules) \
  (SelectionNotMoleculeById) \
  (SelectionMoleculeByOrder) \
  (SelectionMoleculeOfAtom) \
  (SelectionNotMoleculeByOrder) \
  (SelectionMoleculeByName) \
  (SelectionMoleculeById) \
  (SelectionAllMolecules) \
  (SelectionClearAllMolecules) \
  (SelectionInvertMolecules) \
  (SelectionMoleculeByFormula) \
  (SelectionNotMoleculeByFormula) \
  (SelectionNotMoleculeByName) \
  (SelectionNotAtomById) \
  (SelectionNotAtomByOrder) \
  (SelectionAllAtoms) \
  (SelectionClearAllAtoms) \
  (SelectionInvertAtoms) \
  (SelectionNotAllAtoms) \
  (SelectionNotAtomByElement) \
  (SelectionAllAtomsInsideVolume) \
  (SelectionAllAtomsOfMolecule) \
  (SelectionNotAllAtomsInsideVolume) \
  (SelectionAtomByElement) \
  (SelectionNotAllAtomsOfMolecule) \
  (SelectionAtomById) \
  (SelectionAtomByOrder) \
  (SelectionAllShapes) \
  (SelectionShapeByName) \
  (SelectionNotAllShapes) \
  (SelectionNotShapeByName) \
  (FragmentationAnalyseFragmentationResults) \
  (FragmentationFragmentation) \
  (FragmentationStoreSaturatedFragment) \
  (FillRegularGrid) \
  (FillSurface) \
  (ShapeCombineShapes) \
  (ShapeCreateShape) \
  (ShapeRemoveShape) \
  (ShapeRotateShape) \
  (ShapeStretchShape) \
  (ShapeTranslateShape)

// we need to append the automation action in case we have the JobMarket
#ifdef HAVE_JOBMARKET
#define GLOBALLISTOFACTIONS_JOBMARKET \
    BOOST_PP_SEQ_PUSH_BACK( \
        BOOST_PP_SEQ_PUSH_BACK( \
            GLOBALLISTOFACTIONS_initial, \
            FragmentationFragmentationAutomation \
        ), \
        FragmentationParseFragmentJobs \
    )
#else
#define GLOBALLISTOFACTIONS_JOBMARKET \
    GLOBALLISTOFACTIONS_initial
#endif /* HAVE_JOBMARKET */

#ifdef HAVE_LEVMAR
#define GLOBALLISTOFACTIONS_LEVMAR \
    BOOST_PP_SEQ_PUSH_BACK( \
        GLOBALLISTOFACTIONS_JOBMARKET, \
        FragmentationFitPotential \
    )
#else
#define GLOBALLISTOFACTIONS_LEVMAR \
    GLOBALLISTOFACTIONS_JOBMARKET
#endif /* HAVE_LEVMAR */

// define final list
#define GLOBALLISTOFACTIONS GLOBALLISTOFACTIONS_LEVMAR

#endif /* GLOBALLISTOFACTIONS_HPP_ */

