/*
 * TesselationHelpers.hpp
 *
 *  Auxiliary functions for the tesselation.
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef TESSELATIONHELPERS_HPP_
#define TESSELATIONHELPERS_HPP_

using namespace std;

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define HULLEPSILON 1e-7

#include <gsl/gsl_linalg.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_multimin.h>
#include <gsl/gsl_permutation.h>
#include <gsl/gsl_vector.h>

#include "vector.hpp"

double DetGet(gsl_matrix *A, int inPlace);
void GetSphere(Vector *center, Vector &a, Vector &b, Vector &c, double RADIUS);
void GetCenterOfSphere(Vector* Center, Vector a, Vector b, Vector c, Vector *NewUmkreismittelpunkt, Vector* Direction, Vector* AlternativeDirection, double HalfplaneIndicator, double AlternativeIndicator, double alpha, double beta, double gamma, double RADIUS, double Umkreisradius);
void GetCenterofCircumcircle(Vector *Center, Vector *a, Vector *b, Vector *c);
double GetPathLengthonCircumCircle(Vector &CircleCenter, Vector &CirclePlaneNormal, double CircleRadius, Vector &NewSphereCenter, Vector &OldSphereCenter, Vector &NormalVector, Vector &SearchDirection);
double MinIntersectDistance(const gsl_vector * x, void *params);
bool existsIntersection(Vector point1, Vector point2, Vector point3, Vector point4);

#endif /* TESSELATIONHELPERS_HPP_ */
