/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ValueTest.cpp
 *
 *  Created on: Apr 13, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ValueTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parameters/Value.hpp"
#include "Parameters/Validators/DiscreteValidator.hpp"
#include "Parameters/Validators/DummyValidator.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ValueTest );


void ValueTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  for (int i=1; i<=3;++i) {
    ValidValues.push_back(i);
  }
}

void ValueTest::tearDown()
{
  ValidValues.clear();
}

/************************************ tests ***********************************/


/** Unit test for isValid.
 *
 */
void ValueTest::isValidTest()
{
  // create instance
  Value<int> test(ValidValues);

  // checking valid values
  for (int i=1; i<=3;++i)
    CPPUNIT_ASSERT_EQUAL(true, test.isValid(i));

  // checking invalid values
  for (int i=-10; i<=0;++i)
    CPPUNIT_ASSERT_EQUAL(false, test.isValid(i));
  for (int i=4; i<=0;++i)
    CPPUNIT_ASSERT_EQUAL(false, test.isValid(i));
}

/** Unit test for appendValidValue.
 *
 */
void ValueTest::appendValidValueTest()
{
  // create instance
/*  Value<int> test(ValidValues);

  // adding values 4,5,6
  for (int i=4; i<=6;++i) {
    CPPUNIT_ASSERT_EQUAL(false, test.isValidValue(i));
    test.appendValidValue(i);
    CPPUNIT_ASSERT_EQUAL(true, test.isValidValue(i));
  }

  // adding same value, throws assertion
  const size_t size_before = test.ValidValues.size();
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  for (int i=1; i<=6;++i)
    CPPUNIT_ASSERT_THROW(test.appendValidValue(i), Assert::AssertionFailure);
#endif
  CPPUNIT_ASSERT_EQUAL( size_before, test.ValidValues.size() );

  // checking valid values
  for (int i=1; i<=6;++i)
    CPPUNIT_ASSERT_EQUAL(true, test.isValidValue(i));

  // checking invalid values
  for (int i=-10; i<=0;++i)
    CPPUNIT_ASSERT_EQUAL(false, test.isValidValue(i));

  // checking invalid values
  for (int i=7; i<=10;++i)
    CPPUNIT_ASSERT_EQUAL(false, test.isValidValue(i));*/
}

/** Unit test for setters and getters.
 *
 */
void ValueTest::settergetterTest()
{
  // create instance
  Value<int> test(ValidValues);

  // unset calling of get, throws
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.get(), Assert::AssertionFailure);
#endif

  // setting invalid, throws
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.set(4), Assert::AssertionFailure);
#endif
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.set(0), Assert::AssertionFailure);
#endif

  // checking all valid ones
  for (int i=1; i<=3;++i) {
    test.set(i);
    CPPUNIT_ASSERT_EQUAL(i, test.get());
  }

}

/** Unit test for comparator.
 *
 */
void ValueTest::comparatorTest()
{
  {
    // create instance
    Value<int> test(ValidValues);
    Value<int> instance(ValidValues);
    test.set(1);
    instance.set(1);

    // same value, same range
    {
      CPPUNIT_ASSERT(test == instance);
    }

    // different value, same range
    {
      const int oldvalue = instance.get();
      instance.set(2);
      CPPUNIT_ASSERT(test != instance);
      instance.set(oldvalue);
    }
  }
  {
    Value<int> test(ValidValues);
    Value<int> instance(ValidValues);
//    instance.appendValidValue(4); TODO

    test.set(1);
    instance.set(1);

    // same value, same range
    {
      //CPPUNIT_ASSERT(test != instance);
    }

    // different value, same range
    {
      const int oldvalue = instance.get();
      instance.set(2);
      CPPUNIT_ASSERT(test != instance);
      instance.set(oldvalue);
    }
  }
}
