/*
 * Value_impl.hpp
 *
 *  Created on: Apr 13, 2012
 *      Author: ankele
 */

#ifndef VALUE_IMPL_HPP_
#define VALUE_IMPL_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <boost/any.hpp>

#include "CodePatterns/Assert.hpp"

#include "CodePatterns/Log.hpp"

#include "Validators/DiscreteValidator.hpp"
#include "Validators/RangeValidator.hpp"

/** Constructor of class Value.
 */
template <class T>
Value<T>::Value() :
  ValueSet(false),
  validator(NULL)
{}

/** Constructor of class Value with a validator.
 *
 * @param _validator general validator to use
 */
template <class T>
Value<T>::Value(const Validator<T> &_validator) :
  ValueSet(false),
  validator(_validator.clone())
{}

/** Constructor of class Value with a discrete validator.
 *
 * @param _ValidValues vector with all valid values
 */
template <class T>
Value<T>::Value(const std::vector<T> &_ValidValues) :
  ValueSet(false),
  validator(NULL)
{
  validator = new DiscreteValidator<T>(_ValidValues);
}

/** Constructor of class Value with a range validator.
 *
 * @param _ValidRange range of valid values
 */
template <class T>
Value<T>::Value(const range<T> &_ValidRange) :
  ValueSet(false),
  validator(NULL)
{
  validator = new RangeValidator<T>(_ValidRange);
}

/** Destructor of class Value.
 */
template <class T>
Value<T>::~Value()
{
  if (validator)
    delete(validator);
}

/** Checks whether \a _value is a valid value.
 * \param _value value to check for validity.
 * \return true - \a _value is valid, false - is not
 */
template <class T>
bool Value<T>::isValid(const T & _value) const
{
  if (validator)
    return (*validator)(_value);
  return true;
}

/** Compares this discrete value against another \a _instance.
 *
 * @param _instance other value to compare to
 * @return true - if value and valid ranges are the same, false - else
 */
template <class T>
bool Value<T>::operator==(const Value<T> &_instance) const
{
  bool status = true;
  //status = status && (ValidValues == _instance.ValidValues); // TODO
  status = status && (ValueSet == _instance.ValueSet);
  if (ValueSet && _instance.ValueSet)
    status = status && (value == _instance.value);
  return status;
}


/** Getter of value
 *
 * @return value
 */
template <class T>
const T & Value<T>::get() const
{
  ASSERT(ValueSet,
      "Value<T>::get() - value has never been set.");
  return value;
}

/** Setter of value
 *
 * @param _value new value
 */
template <class T>
void Value<T>::set(const T & _value)
{
  ASSERT(isValid(_value),
      "Value<T>::setValue() - trying to set invalid value "+toString(_value)+".");
  if (!ValueSet)
    ValueSet = true;
  value = _value;
}

/** Returns the validator.
 *
 * @return the validator
 */
template <class T>
const Validator<T> &Value<T>::getValidator() const
{
  return *validator;
}



#endif /* VALUE_IMPL_HPP_ */
