/*
 * Value.hpp
 *
 *  Created on: Apr 13, 2012
 *      Author: ankele
 */

#ifndef VALUE_HPP_
#define VALUE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#include "ValueInterface.hpp"
#include "Validators/Validator.hpp"

#include "CodePatterns/Range.hpp"

class ValueTest;

/** This class represents a general value.
 *
 */
template <class T>
class Value : virtual public ValueInterface<T>
{
  //!> unit test needs to have access to internal values
  friend class ValueTest;
public:
  Value();
  Value(const Validator<T> &_validator);
  Value(const std::vector<T> &_ValidValues);
  Value(const range<T> &_ValidRange);
  virtual ~Value();

  // functions for ValueInterface
  bool isValid(const T &_value) const;
  const T & get() const;
  void set(const T & _value);

  // comfortable setter
  void operator=(const T &_value)
  { set(_value);  }

  // comparator
  bool operator==(const Value<T> &_instance) const;
  bool operator!=(const Value<T> &_instance) const
      { return !((*this)==(_instance)); }

  // setter/getter for valid values
  /*void appendValidValue(const T &_value);
  const std::vector<T> &getValidValues() const;

  // internal getter and setter
  bool isValidValue(const T &_value) const;
  void setValue(const T &_value);
  const T & getValue() const;
  const size_t getIndexOfValue() const { return value; }

private:
  const size_t findIndexOfValue(const T &_value) const;*/

  const Validator<T> & getValidator() const;

private:

  //!> whether a value has been set or not
  bool ValueSet;
  //!> contained value
  T value;

  //!> the validator
  Validator<T> *validator;
};

#include "Value_impl.hpp"


#endif /* VALUE_HPP_ */
